/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.identitymanagement.model.CreateRoleRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateRoleRequestMarshaller
implements Marshaller<Request<CreateRoleRequest>, CreateRoleRequest> {
    public Request<CreateRoleRequest> marshall(CreateRoleRequest createRoleRequest) {
        if (createRoleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createRoleRequest, "AmazonIdentityManagement");
        request.addParameter("Action", "CreateRole");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (createRoleRequest.getPath() != null) {
            request.addParameter("Path", StringUtils.fromString((String)createRoleRequest.getPath()));
        }
        if (createRoleRequest.getRoleName() != null) {
            request.addParameter("RoleName", StringUtils.fromString((String)createRoleRequest.getRoleName()));
        }
        if (createRoleRequest.getAssumeRolePolicyDocument() != null) {
            request.addParameter("AssumeRolePolicyDocument", StringUtils.fromString((String)createRoleRequest.getAssumeRolePolicyDocument()));
        }
        if (createRoleRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createRoleRequest.getDescription()));
        }
        if (createRoleRequest.getMaxSessionDuration() != null) {
            request.addParameter("MaxSessionDuration", StringUtils.fromInteger((Integer)createRoleRequest.getMaxSessionDuration()));
        }
        if (createRoleRequest.getPermissionsBoundary() != null) {
            request.addParameter("PermissionsBoundary", StringUtils.fromString((String)createRoleRequest.getPermissionsBoundary()));
        }
        return request;
    }
}

