/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.identitymanagement.model.PolicyEvaluationDecisionType;
import com.amazonaws.services.identitymanagement.model.Statement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EvaluationResult
implements Serializable,
Cloneable {
    private String evalActionName;
    private String evalResourceName;
    private String evalDecision;
    private ListWithAutoConstructFlag<Statement> matchedStatements;
    private ListWithAutoConstructFlag<String> missingContextValues;
    private Map<String, String> evalDecisionDetails;

    public String getEvalActionName() {
        return this.evalActionName;
    }

    public void setEvalActionName(String evalActionName) {
        this.evalActionName = evalActionName;
    }

    public EvaluationResult withEvalActionName(String evalActionName) {
        this.evalActionName = evalActionName;
        return this;
    }

    public String getEvalResourceName() {
        return this.evalResourceName;
    }

    public void setEvalResourceName(String evalResourceName) {
        this.evalResourceName = evalResourceName;
    }

    public EvaluationResult withEvalResourceName(String evalResourceName) {
        this.evalResourceName = evalResourceName;
        return this;
    }

    public String getEvalDecision() {
        return this.evalDecision;
    }

    public void setEvalDecision(String evalDecision) {
        this.evalDecision = evalDecision;
    }

    public EvaluationResult withEvalDecision(String evalDecision) {
        this.evalDecision = evalDecision;
        return this;
    }

    public void setEvalDecision(PolicyEvaluationDecisionType evalDecision) {
        this.evalDecision = evalDecision.toString();
    }

    public EvaluationResult withEvalDecision(PolicyEvaluationDecisionType evalDecision) {
        this.evalDecision = evalDecision.toString();
        return this;
    }

    public List<Statement> getMatchedStatements() {
        if (this.matchedStatements == null) {
            this.matchedStatements = new ListWithAutoConstructFlag();
            this.matchedStatements.setAutoConstruct(true);
        }
        return this.matchedStatements;
    }

    public void setMatchedStatements(Collection<Statement> matchedStatements) {
        if (matchedStatements == null) {
            this.matchedStatements = null;
            return;
        }
        ListWithAutoConstructFlag matchedStatementsCopy = new ListWithAutoConstructFlag(matchedStatements.size());
        matchedStatementsCopy.addAll(matchedStatements);
        this.matchedStatements = matchedStatementsCopy;
    }

    public EvaluationResult withMatchedStatements(Statement ... matchedStatements) {
        if (this.getMatchedStatements() == null) {
            this.setMatchedStatements(new ArrayList<Statement>(matchedStatements.length));
        }
        for (Statement value : matchedStatements) {
            this.getMatchedStatements().add(value);
        }
        return this;
    }

    public EvaluationResult withMatchedStatements(Collection<Statement> matchedStatements) {
        if (matchedStatements == null) {
            this.matchedStatements = null;
        } else {
            ListWithAutoConstructFlag matchedStatementsCopy = new ListWithAutoConstructFlag(matchedStatements.size());
            matchedStatementsCopy.addAll(matchedStatements);
            this.matchedStatements = matchedStatementsCopy;
        }
        return this;
    }

    public List<String> getMissingContextValues() {
        if (this.missingContextValues == null) {
            this.missingContextValues = new ListWithAutoConstructFlag();
            this.missingContextValues.setAutoConstruct(true);
        }
        return this.missingContextValues;
    }

    public void setMissingContextValues(Collection<String> missingContextValues) {
        if (missingContextValues == null) {
            this.missingContextValues = null;
            return;
        }
        ListWithAutoConstructFlag missingContextValuesCopy = new ListWithAutoConstructFlag(missingContextValues.size());
        missingContextValuesCopy.addAll(missingContextValues);
        this.missingContextValues = missingContextValuesCopy;
    }

    public EvaluationResult withMissingContextValues(String ... missingContextValues) {
        if (this.getMissingContextValues() == null) {
            this.setMissingContextValues(new ArrayList<String>(missingContextValues.length));
        }
        for (String value : missingContextValues) {
            this.getMissingContextValues().add(value);
        }
        return this;
    }

    public EvaluationResult withMissingContextValues(Collection<String> missingContextValues) {
        if (missingContextValues == null) {
            this.missingContextValues = null;
        } else {
            ListWithAutoConstructFlag missingContextValuesCopy = new ListWithAutoConstructFlag(missingContextValues.size());
            missingContextValuesCopy.addAll(missingContextValues);
            this.missingContextValues = missingContextValuesCopy;
        }
        return this;
    }

    public Map<String, String> getEvalDecisionDetails() {
        if (this.evalDecisionDetails == null) {
            this.evalDecisionDetails = new HashMap<String, String>();
        }
        return this.evalDecisionDetails;
    }

    public void setEvalDecisionDetails(Map<String, String> evalDecisionDetails) {
        this.evalDecisionDetails = evalDecisionDetails;
    }

    public EvaluationResult withEvalDecisionDetails(Map<String, String> evalDecisionDetails) {
        this.setEvalDecisionDetails(evalDecisionDetails);
        return this;
    }

    public EvaluationResult addEvalDecisionDetailsEntry(String key, String value) {
        if (null == this.evalDecisionDetails) {
            this.evalDecisionDetails = new HashMap<String, String>();
        }
        if (this.evalDecisionDetails.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.evalDecisionDetails.put(key, value);
        return this;
    }

    public EvaluationResult clearEvalDecisionDetailsEntries() {
        this.evalDecisionDetails = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEvalActionName() != null) {
            sb.append("EvalActionName: " + this.getEvalActionName() + ",");
        }
        if (this.getEvalResourceName() != null) {
            sb.append("EvalResourceName: " + this.getEvalResourceName() + ",");
        }
        if (this.getEvalDecision() != null) {
            sb.append("EvalDecision: " + this.getEvalDecision() + ",");
        }
        if (this.getMatchedStatements() != null) {
            sb.append("MatchedStatements: " + this.getMatchedStatements() + ",");
        }
        if (this.getMissingContextValues() != null) {
            sb.append("MissingContextValues: " + this.getMissingContextValues() + ",");
        }
        if (this.getEvalDecisionDetails() != null) {
            sb.append("EvalDecisionDetails: " + this.getEvalDecisionDetails());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEvalActionName() == null ? 0 : this.getEvalActionName().hashCode());
        hashCode = 31 * hashCode + (this.getEvalResourceName() == null ? 0 : this.getEvalResourceName().hashCode());
        hashCode = 31 * hashCode + (this.getEvalDecision() == null ? 0 : this.getEvalDecision().hashCode());
        hashCode = 31 * hashCode + (this.getMatchedStatements() == null ? 0 : this.getMatchedStatements().hashCode());
        hashCode = 31 * hashCode + (this.getMissingContextValues() == null ? 0 : this.getMissingContextValues().hashCode());
        hashCode = 31 * hashCode + (this.getEvalDecisionDetails() == null ? 0 : this.getEvalDecisionDetails().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationResult)) {
            return false;
        }
        EvaluationResult other = (EvaluationResult)obj;
        if (other.getEvalActionName() == null ^ this.getEvalActionName() == null) {
            return false;
        }
        if (other.getEvalActionName() != null && !other.getEvalActionName().equals(this.getEvalActionName())) {
            return false;
        }
        if (other.getEvalResourceName() == null ^ this.getEvalResourceName() == null) {
            return false;
        }
        if (other.getEvalResourceName() != null && !other.getEvalResourceName().equals(this.getEvalResourceName())) {
            return false;
        }
        if (other.getEvalDecision() == null ^ this.getEvalDecision() == null) {
            return false;
        }
        if (other.getEvalDecision() != null && !other.getEvalDecision().equals(this.getEvalDecision())) {
            return false;
        }
        if (other.getMatchedStatements() == null ^ this.getMatchedStatements() == null) {
            return false;
        }
        if (other.getMatchedStatements() != null && !other.getMatchedStatements().equals(this.getMatchedStatements())) {
            return false;
        }
        if (other.getMissingContextValues() == null ^ this.getMissingContextValues() == null) {
            return false;
        }
        if (other.getMissingContextValues() != null && !other.getMissingContextValues().equals(this.getMissingContextValues())) {
            return false;
        }
        if (other.getEvalDecisionDetails() == null ^ this.getEvalDecisionDetails() == null) {
            return false;
        }
        return other.getEvalDecisionDetails() == null || other.getEvalDecisionDetails().equals(this.getEvalDecisionDetails());
    }

    public EvaluationResult clone() {
        try {
            return (EvaluationResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

