/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.identitymanagement.model.ContextEntry;
import com.amazonaws.services.identitymanagement.model.SimulateCustomPolicyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class SimulateCustomPolicyRequestMarshaller
implements Marshaller<Request<SimulateCustomPolicyRequest>, SimulateCustomPolicyRequest> {
    public Request<SimulateCustomPolicyRequest> marshall(SimulateCustomPolicyRequest simulateCustomPolicyRequest) {
        if (simulateCustomPolicyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)simulateCustomPolicyRequest, "AmazonIdentityManagement");
        request.addParameter("Action", "SimulateCustomPolicy");
        request.addParameter("Version", "2010-05-08");
        List<String> policyInputListList = simulateCustomPolicyRequest.getPolicyInputList();
        int policyInputListListIndex = 1;
        for (String policyInputListListValue : policyInputListList) {
            if (policyInputListListValue != null) {
                request.addParameter("PolicyInputList.member." + policyInputListListIndex, StringUtils.fromString((String)policyInputListListValue));
            }
            ++policyInputListListIndex;
        }
        List<String> actionNamesList = simulateCustomPolicyRequest.getActionNames();
        int actionNamesListIndex = 1;
        for (String actionNamesListValue : actionNamesList) {
            if (actionNamesListValue != null) {
                request.addParameter("ActionNames.member." + actionNamesListIndex, StringUtils.fromString((String)actionNamesListValue));
            }
            ++actionNamesListIndex;
        }
        List<String> resourceArnsList = simulateCustomPolicyRequest.getResourceArns();
        int resourceArnsListIndex = 1;
        for (String resourceArnsListValue : resourceArnsList) {
            if (resourceArnsListValue != null) {
                request.addParameter("ResourceArns.member." + resourceArnsListIndex, StringUtils.fromString((String)resourceArnsListValue));
            }
            ++resourceArnsListIndex;
        }
        List<ContextEntry> contextEntriesList = simulateCustomPolicyRequest.getContextEntries();
        int contextEntriesListIndex = 1;
        for (ContextEntry contextEntriesListValue : contextEntriesList) {
            ContextEntry contextEntryMember = contextEntriesListValue;
            if (contextEntryMember != null) {
                if (contextEntryMember.getContextKeyName() != null) {
                    request.addParameter("ContextEntries.member." + contextEntriesListIndex + ".ContextKeyName", StringUtils.fromString((String)contextEntryMember.getContextKeyName()));
                }
                List<String> contextKeyValuesList = contextEntryMember.getContextKeyValues();
                int contextKeyValuesListIndex = 1;
                for (String contextKeyValuesListValue : contextKeyValuesList) {
                    if (contextKeyValuesListValue != null) {
                        request.addParameter("ContextEntries.member." + contextEntriesListIndex + ".ContextKeyValues.member." + contextKeyValuesListIndex, StringUtils.fromString((String)contextKeyValuesListValue));
                    }
                    ++contextKeyValuesListIndex;
                }
                if (contextEntryMember.getContextKeyType() != null) {
                    request.addParameter("ContextEntries.member." + contextEntriesListIndex + ".ContextKeyType", StringUtils.fromString((String)contextEntryMember.getContextKeyType()));
                }
            }
            ++contextEntriesListIndex;
        }
        if (simulateCustomPolicyRequest.getMaxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger((Integer)simulateCustomPolicyRequest.getMaxItems()));
        }
        if (simulateCustomPolicyRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)simulateCustomPolicyRequest.getMarker()));
        }
        return request;
    }
}

