/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.health.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.health.model.EntityStatusCode;
import com.amazonaws.services.health.model.transform.EntityAccountFilterMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EntityAccountFilter
implements Serializable,
Cloneable,
StructuredPojo {
    private String eventArn;
    private String awsAccountId;
    private List<String> statusCodes;

    public void setEventArn(String eventArn) {
        this.eventArn = eventArn;
    }

    public String getEventArn() {
        return this.eventArn;
    }

    public EntityAccountFilter withEventArn(String eventArn) {
        this.setEventArn(eventArn);
        return this;
    }

    public void setAwsAccountId(String awsAccountId) {
        this.awsAccountId = awsAccountId;
    }

    public String getAwsAccountId() {
        return this.awsAccountId;
    }

    public EntityAccountFilter withAwsAccountId(String awsAccountId) {
        this.setAwsAccountId(awsAccountId);
        return this;
    }

    public List<String> getStatusCodes() {
        return this.statusCodes;
    }

    public void setStatusCodes(Collection<String> statusCodes) {
        if (statusCodes == null) {
            this.statusCodes = null;
            return;
        }
        this.statusCodes = new ArrayList<String>(statusCodes);
    }

    public EntityAccountFilter withStatusCodes(String ... statusCodes) {
        if (this.statusCodes == null) {
            this.setStatusCodes(new ArrayList<String>(statusCodes.length));
        }
        for (String ele : statusCodes) {
            this.statusCodes.add(ele);
        }
        return this;
    }

    public EntityAccountFilter withStatusCodes(Collection<String> statusCodes) {
        this.setStatusCodes(statusCodes);
        return this;
    }

    public EntityAccountFilter withStatusCodes(EntityStatusCode ... statusCodes) {
        ArrayList<String> statusCodesCopy = new ArrayList<String>(statusCodes.length);
        for (EntityStatusCode value : statusCodes) {
            statusCodesCopy.add(value.toString());
        }
        if (this.getStatusCodes() == null) {
            this.setStatusCodes(statusCodesCopy);
        } else {
            this.getStatusCodes().addAll(statusCodesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEventArn() != null) {
            sb.append("EventArn: ").append(this.getEventArn()).append(",");
        }
        if (this.getAwsAccountId() != null) {
            sb.append("AwsAccountId: ").append(this.getAwsAccountId()).append(",");
        }
        if (this.getStatusCodes() != null) {
            sb.append("StatusCodes: ").append(this.getStatusCodes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityAccountFilter)) {
            return false;
        }
        EntityAccountFilter other = (EntityAccountFilter)obj;
        if (other.getEventArn() == null ^ this.getEventArn() == null) {
            return false;
        }
        if (other.getEventArn() != null && !other.getEventArn().equals(this.getEventArn())) {
            return false;
        }
        if (other.getAwsAccountId() == null ^ this.getAwsAccountId() == null) {
            return false;
        }
        if (other.getAwsAccountId() != null && !other.getAwsAccountId().equals(this.getAwsAccountId())) {
            return false;
        }
        if (other.getStatusCodes() == null ^ this.getStatusCodes() == null) {
            return false;
        }
        return other.getStatusCodes() == null || other.getStatusCodes().equals(this.getStatusCodes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEventArn() == null ? 0 : this.getEventArn().hashCode());
        hashCode = 31 * hashCode + (this.getAwsAccountId() == null ? 0 : this.getAwsAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getStatusCodes() == null ? 0 : this.getStatusCodes().hashCode());
        return hashCode;
    }

    public EntityAccountFilter clone() {
        try {
            return (EntityAccountFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EntityAccountFilterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

