/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.guardduty.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.guardduty.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * GetMalwareProtectionPlanResult JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class GetMalwareProtectionPlanResultJsonUnmarshaller implements Unmarshaller<GetMalwareProtectionPlanResult, JsonUnmarshallerContext> {

    public GetMalwareProtectionPlanResult unmarshall(JsonUnmarshallerContext context) throws Exception {
        GetMalwareProtectionPlanResult getMalwareProtectionPlanResult = new GetMalwareProtectionPlanResult();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return getMalwareProtectionPlanResult;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("arn", targetDepth)) {
                    context.nextToken();
                    getMalwareProtectionPlanResult.setArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("role", targetDepth)) {
                    context.nextToken();
                    getMalwareProtectionPlanResult.setRole(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("protectedResource", targetDepth)) {
                    context.nextToken();
                    getMalwareProtectionPlanResult.setProtectedResource(CreateProtectedResourceJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("actions", targetDepth)) {
                    context.nextToken();
                    getMalwareProtectionPlanResult.setActions(MalwareProtectionPlanActionsJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("createdAt", targetDepth)) {
                    context.nextToken();
                    getMalwareProtectionPlanResult.setCreatedAt(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("status", targetDepth)) {
                    context.nextToken();
                    getMalwareProtectionPlanResult.setStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("statusReasons", targetDepth)) {
                    context.nextToken();
                    getMalwareProtectionPlanResult.setStatusReasons(new ListUnmarshaller<MalwareProtectionPlanStatusReason>(
                            MalwareProtectionPlanStatusReasonJsonUnmarshaller.getInstance())

                    .unmarshall(context));
                }
                if (context.testExpression("tags", targetDepth)) {
                    context.nextToken();
                    getMalwareProtectionPlanResult.setTags(new MapUnmarshaller<String, String>(context.getUnmarshaller(String.class), context
                            .getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return getMalwareProtectionPlanResult;
    }

    private static GetMalwareProtectionPlanResultJsonUnmarshaller instance;

    public static GetMalwareProtectionPlanResultJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new GetMalwareProtectionPlanResultJsonUnmarshaller();
        return instance;
    }
}
