/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.guardduty.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.guardduty.model.AnomalyObject;
import com.amazonaws.services.guardduty.model.AnomalyUnusual;
import com.amazonaws.services.guardduty.model.transform.AnomalyMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Anomaly
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, Map<String, List<AnomalyObject>>> profiles;
    private AnomalyUnusual unusual;

    public Map<String, Map<String, List<AnomalyObject>>> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(Map<String, Map<String, List<AnomalyObject>>> profiles) {
        this.profiles = profiles;
    }

    public Anomaly withProfiles(Map<String, Map<String, List<AnomalyObject>>> profiles) {
        this.setProfiles(profiles);
        return this;
    }

    public Anomaly addProfilesEntry(String key, Map<String, List<AnomalyObject>> value) {
        if (null == this.profiles) {
            this.profiles = new HashMap<String, Map<String, List<AnomalyObject>>>();
        }
        if (this.profiles.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.profiles.put(key, value);
        return this;
    }

    public Anomaly clearProfilesEntries() {
        this.profiles = null;
        return this;
    }

    public void setUnusual(AnomalyUnusual unusual) {
        this.unusual = unusual;
    }

    public AnomalyUnusual getUnusual() {
        return this.unusual;
    }

    public Anomaly withUnusual(AnomalyUnusual unusual) {
        this.setUnusual(unusual);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProfiles() != null) {
            sb.append("Profiles: ").append(this.getProfiles()).append(",");
        }
        if (this.getUnusual() != null) {
            sb.append("Unusual: ").append(this.getUnusual());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Anomaly)) {
            return false;
        }
        Anomaly other = (Anomaly)obj;
        if (other.getProfiles() == null ^ this.getProfiles() == null) {
            return false;
        }
        if (other.getProfiles() != null && !other.getProfiles().equals(this.getProfiles())) {
            return false;
        }
        if (other.getUnusual() == null ^ this.getUnusual() == null) {
            return false;
        }
        return other.getUnusual() == null || other.getUnusual().equals(this.getUnusual());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProfiles() == null ? 0 : this.getProfiles().hashCode());
        hashCode = 31 * hashCode + (this.getUnusual() == null ? 0 : this.getUnusual().hashCode());
        return hashCode;
    }

    public Anomaly clone() {
        try {
            return (Anomaly)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AnomalyMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

