/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.groundstation.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.groundstation.AWSGroundStation;
import com.amazonaws.services.groundstation.model.DescribeContactRequest;
import com.amazonaws.services.groundstation.waiters.ContactScheduled;
import com.amazonaws.services.groundstation.waiters.DescribeContactFunction;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterExecutorServiceFactory;
import java.util.concurrent.ExecutorService;

public class AWSGroundStationWaiters {
    private final AWSGroundStation client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter((String)"AWSGroundStationWaiters");

    @SdkInternalApi
    public AWSGroundStationWaiters(AWSGroundStation client) {
        this.client = client;
    }

    public Waiter<DescribeContactRequest> contactScheduled() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeContactFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new ContactScheduled.IsFAILED_TO_SCHEDULEMatcher(), new ContactScheduled.IsSCHEDULEDMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(180), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

