/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.groundstation.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.groundstation.model.EphemerisMetaData;
import com.amazonaws.services.groundstation.model.transform.SatelliteListItemMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SatelliteListItem
implements Serializable,
Cloneable,
StructuredPojo {
    private EphemerisMetaData currentEphemeris;
    private List<String> groundStations;
    private Integer noradSatelliteID;
    private String satelliteArn;
    private String satelliteId;

    public void setCurrentEphemeris(EphemerisMetaData currentEphemeris) {
        this.currentEphemeris = currentEphemeris;
    }

    public EphemerisMetaData getCurrentEphemeris() {
        return this.currentEphemeris;
    }

    public SatelliteListItem withCurrentEphemeris(EphemerisMetaData currentEphemeris) {
        this.setCurrentEphemeris(currentEphemeris);
        return this;
    }

    public List<String> getGroundStations() {
        return this.groundStations;
    }

    public void setGroundStations(Collection<String> groundStations) {
        if (groundStations == null) {
            this.groundStations = null;
            return;
        }
        this.groundStations = new ArrayList<String>(groundStations);
    }

    public SatelliteListItem withGroundStations(String ... groundStations) {
        if (this.groundStations == null) {
            this.setGroundStations(new ArrayList<String>(groundStations.length));
        }
        for (String ele : groundStations) {
            this.groundStations.add(ele);
        }
        return this;
    }

    public SatelliteListItem withGroundStations(Collection<String> groundStations) {
        this.setGroundStations(groundStations);
        return this;
    }

    public void setNoradSatelliteID(Integer noradSatelliteID) {
        this.noradSatelliteID = noradSatelliteID;
    }

    public Integer getNoradSatelliteID() {
        return this.noradSatelliteID;
    }

    public SatelliteListItem withNoradSatelliteID(Integer noradSatelliteID) {
        this.setNoradSatelliteID(noradSatelliteID);
        return this;
    }

    public void setSatelliteArn(String satelliteArn) {
        this.satelliteArn = satelliteArn;
    }

    public String getSatelliteArn() {
        return this.satelliteArn;
    }

    public SatelliteListItem withSatelliteArn(String satelliteArn) {
        this.setSatelliteArn(satelliteArn);
        return this;
    }

    public void setSatelliteId(String satelliteId) {
        this.satelliteId = satelliteId;
    }

    public String getSatelliteId() {
        return this.satelliteId;
    }

    public SatelliteListItem withSatelliteId(String satelliteId) {
        this.setSatelliteId(satelliteId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCurrentEphemeris() != null) {
            sb.append("CurrentEphemeris: ").append(this.getCurrentEphemeris()).append(",");
        }
        if (this.getGroundStations() != null) {
            sb.append("GroundStations: ").append(this.getGroundStations()).append(",");
        }
        if (this.getNoradSatelliteID() != null) {
            sb.append("NoradSatelliteID: ").append(this.getNoradSatelliteID()).append(",");
        }
        if (this.getSatelliteArn() != null) {
            sb.append("SatelliteArn: ").append(this.getSatelliteArn()).append(",");
        }
        if (this.getSatelliteId() != null) {
            sb.append("SatelliteId: ").append(this.getSatelliteId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SatelliteListItem)) {
            return false;
        }
        SatelliteListItem other = (SatelliteListItem)obj;
        if (other.getCurrentEphemeris() == null ^ this.getCurrentEphemeris() == null) {
            return false;
        }
        if (other.getCurrentEphemeris() != null && !other.getCurrentEphemeris().equals(this.getCurrentEphemeris())) {
            return false;
        }
        if (other.getGroundStations() == null ^ this.getGroundStations() == null) {
            return false;
        }
        if (other.getGroundStations() != null && !other.getGroundStations().equals(this.getGroundStations())) {
            return false;
        }
        if (other.getNoradSatelliteID() == null ^ this.getNoradSatelliteID() == null) {
            return false;
        }
        if (other.getNoradSatelliteID() != null && !other.getNoradSatelliteID().equals(this.getNoradSatelliteID())) {
            return false;
        }
        if (other.getSatelliteArn() == null ^ this.getSatelliteArn() == null) {
            return false;
        }
        if (other.getSatelliteArn() != null && !other.getSatelliteArn().equals(this.getSatelliteArn())) {
            return false;
        }
        if (other.getSatelliteId() == null ^ this.getSatelliteId() == null) {
            return false;
        }
        return other.getSatelliteId() == null || other.getSatelliteId().equals(this.getSatelliteId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCurrentEphemeris() == null ? 0 : this.getCurrentEphemeris().hashCode());
        hashCode = 31 * hashCode + (this.getGroundStations() == null ? 0 : this.getGroundStations().hashCode());
        hashCode = 31 * hashCode + (this.getNoradSatelliteID() == null ? 0 : this.getNoradSatelliteID().hashCode());
        hashCode = 31 * hashCode + (this.getSatelliteArn() == null ? 0 : this.getSatelliteArn().hashCode());
        hashCode = 31 * hashCode + (this.getSatelliteId() == null ? 0 : this.getSatelliteId().hashCode());
        return hashCode;
    }

    public SatelliteListItem clone() {
        try {
            return (SatelliteListItem)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SatelliteListItemMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

