/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.groundstation.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.groundstation.model.AgentStatus;
import com.amazonaws.services.groundstation.model.transform.AggregateStatusMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class AggregateStatus
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, Boolean> signatureMap;
    private String status;

    public Map<String, Boolean> getSignatureMap() {
        return this.signatureMap;
    }

    public void setSignatureMap(Map<String, Boolean> signatureMap) {
        this.signatureMap = signatureMap;
    }

    public AggregateStatus withSignatureMap(Map<String, Boolean> signatureMap) {
        this.setSignatureMap(signatureMap);
        return this;
    }

    public AggregateStatus addSignatureMapEntry(String key, Boolean value) {
        if (null == this.signatureMap) {
            this.signatureMap = new HashMap<String, Boolean>();
        }
        if (this.signatureMap.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.signatureMap.put(key, value);
        return this;
    }

    public AggregateStatus clearSignatureMapEntries() {
        this.signatureMap = null;
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public AggregateStatus withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public AggregateStatus withStatus(AgentStatus status) {
        this.status = status.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSignatureMap() != null) {
            sb.append("SignatureMap: ").append(this.getSignatureMap()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregateStatus)) {
            return false;
        }
        AggregateStatus other = (AggregateStatus)obj;
        if (other.getSignatureMap() == null ^ this.getSignatureMap() == null) {
            return false;
        }
        if (other.getSignatureMap() != null && !other.getSignatureMap().equals(this.getSignatureMap())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        return other.getStatus() == null || other.getStatus().equals(this.getStatus());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSignatureMap() == null ? 0 : this.getSignatureMap().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        return hashCode;
    }

    public AggregateStatus clone() {
        try {
            return (AggregateStatus)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AggregateStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

