/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.greengrassv2.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.greengrassv2.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * InstalledComponent JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class InstalledComponentJsonUnmarshaller implements Unmarshaller<InstalledComponent, JsonUnmarshallerContext> {

    public InstalledComponent unmarshall(JsonUnmarshallerContext context) throws Exception {
        InstalledComponent installedComponent = new InstalledComponent();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("componentName", targetDepth)) {
                    context.nextToken();
                    installedComponent.setComponentName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("componentVersion", targetDepth)) {
                    context.nextToken();
                    installedComponent.setComponentVersion(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("lifecycleState", targetDepth)) {
                    context.nextToken();
                    installedComponent.setLifecycleState(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("lifecycleStateDetails", targetDepth)) {
                    context.nextToken();
                    installedComponent.setLifecycleStateDetails(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("isRoot", targetDepth)) {
                    context.nextToken();
                    installedComponent.setIsRoot(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("lastStatusChangeTimestamp", targetDepth)) {
                    context.nextToken();
                    installedComponent.setLastStatusChangeTimestamp(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("lastReportedTimestamp", targetDepth)) {
                    context.nextToken();
                    installedComponent.setLastReportedTimestamp(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("lastInstallationSource", targetDepth)) {
                    context.nextToken();
                    installedComponent.setLastInstallationSource(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("lifecycleStatusCodes", targetDepth)) {
                    context.nextToken();
                    installedComponent.setLifecycleStatusCodes(new ListUnmarshaller<String>(context.getUnmarshaller(String.class))

                    .unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return installedComponent;
    }

    private static InstalledComponentJsonUnmarshaller instance;

    public static InstalledComponentJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new InstalledComponentJsonUnmarshaller();
        return instance;
    }
}
