/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.greengrassv2.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Contains information about a component version that is compatible to run on a Greengrass core device.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/greengrassv2-2020-11-30/ResolvedComponentVersion"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ResolvedComponentVersion implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component
     * version.
     * </p>
     */
    private String arn;
    /**
     * <p>
     * The name of the component.
     * </p>
     */
    private String componentName;
    /**
     * <p>
     * The version of the component.
     * </p>
     */
    private String componentVersion;
    /**
     * <p>
     * The recipe of the component version.
     * </p>
     */
    private java.nio.ByteBuffer recipe;
    /**
     * <p>
     * The vendor guidance state for the component version. This state indicates whether the component version has any
     * issues that you should consider before you deploy it. The vendor guidance state can be:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code> – This component version is available and recommended for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISCONTINUED</code> – This component version has been discontinued by its publisher. You can deploy this
     * component version, but we recommend that you use a different version of this component.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code> – This component version has been deleted by its publisher, so you can't deploy it. If you
     * have any existing deployments that specify this component version, those deployments will fail.
     * </p>
     * </li>
     * </ul>
     */
    private String vendorGuidance;
    /**
     * <p>
     * A message that communicates details about the vendor guidance state of the component version. This message
     * communicates why a component version is discontinued or deleted.
     * </p>
     */
    private String message;

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component
     * version.
     * </p>
     * 
     * @param arn
     *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *        component version.
     */

    public void setArn(String arn) {
        this.arn = arn;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component
     * version.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         component version.
     */

    public String getArn() {
        return this.arn;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the component
     * version.
     * </p>
     * 
     * @param arn
     *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *        component version.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ResolvedComponentVersion withArn(String arn) {
        setArn(arn);
        return this;
    }

    /**
     * <p>
     * The name of the component.
     * </p>
     * 
     * @param componentName
     *        The name of the component.
     */

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    /**
     * <p>
     * The name of the component.
     * </p>
     * 
     * @return The name of the component.
     */

    public String getComponentName() {
        return this.componentName;
    }

    /**
     * <p>
     * The name of the component.
     * </p>
     * 
     * @param componentName
     *        The name of the component.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ResolvedComponentVersion withComponentName(String componentName) {
        setComponentName(componentName);
        return this;
    }

    /**
     * <p>
     * The version of the component.
     * </p>
     * 
     * @param componentVersion
     *        The version of the component.
     */

    public void setComponentVersion(String componentVersion) {
        this.componentVersion = componentVersion;
    }

    /**
     * <p>
     * The version of the component.
     * </p>
     * 
     * @return The version of the component.
     */

    public String getComponentVersion() {
        return this.componentVersion;
    }

    /**
     * <p>
     * The version of the component.
     * </p>
     * 
     * @param componentVersion
     *        The version of the component.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ResolvedComponentVersion withComponentVersion(String componentVersion) {
        setComponentVersion(componentVersion);
        return this;
    }

    /**
     * <p>
     * The recipe of the component version.
     * </p>
     * <p>
     * The AWS SDK for Java performs a Base64 encoding on this field before sending this request to the AWS service.
     * Users of the SDK should not perform Base64 encoding on this field.
     * </p>
     * <p>
     * Warning: ByteBuffers returned by the SDK are mutable. Changes to the content or position of the byte buffer will
     * be seen by all objects that have a reference to this object. It is recommended to call ByteBuffer.duplicate() or
     * ByteBuffer.asReadOnlyBuffer() before using or reading from the buffer. This behavior will be changed in a future
     * major version of the SDK.
     * </p>
     * 
     * @param recipe
     *        The recipe of the component version.
     */

    public void setRecipe(java.nio.ByteBuffer recipe) {
        this.recipe = recipe;
    }

    /**
     * <p>
     * The recipe of the component version.
     * </p>
     * <p>
     * {@code ByteBuffer}s are stateful. Calling their {@code get} methods changes their {@code position}. We recommend
     * using {@link java.nio.ByteBuffer#asReadOnlyBuffer()} to create a read-only view of the buffer with an independent
     * {@code position}, and calling {@code get} methods on this rather than directly on the returned {@code ByteBuffer}.
     * Doing so will ensure that anyone else using the {@code ByteBuffer} will not be affected by changes to the
     * {@code position}.
     * </p>
     * 
     * @return The recipe of the component version.
     */

    public java.nio.ByteBuffer getRecipe() {
        return this.recipe;
    }

    /**
     * <p>
     * The recipe of the component version.
     * </p>
     * <p>
     * The AWS SDK for Java performs a Base64 encoding on this field before sending this request to the AWS service.
     * Users of the SDK should not perform Base64 encoding on this field.
     * </p>
     * <p>
     * Warning: ByteBuffers returned by the SDK are mutable. Changes to the content or position of the byte buffer will
     * be seen by all objects that have a reference to this object. It is recommended to call ByteBuffer.duplicate() or
     * ByteBuffer.asReadOnlyBuffer() before using or reading from the buffer. This behavior will be changed in a future
     * major version of the SDK.
     * </p>
     * 
     * @param recipe
     *        The recipe of the component version.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ResolvedComponentVersion withRecipe(java.nio.ByteBuffer recipe) {
        setRecipe(recipe);
        return this;
    }

    /**
     * <p>
     * The vendor guidance state for the component version. This state indicates whether the component version has any
     * issues that you should consider before you deploy it. The vendor guidance state can be:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code> – This component version is available and recommended for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISCONTINUED</code> – This component version has been discontinued by its publisher. You can deploy this
     * component version, but we recommend that you use a different version of this component.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code> – This component version has been deleted by its publisher, so you can't deploy it. If you
     * have any existing deployments that specify this component version, those deployments will fail.
     * </p>
     * </li>
     * </ul>
     * 
     * @param vendorGuidance
     *        The vendor guidance state for the component version. This state indicates whether the component version
     *        has any issues that you should consider before you deploy it. The vendor guidance state can be:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>ACTIVE</code> – This component version is available and recommended for use.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>DISCONTINUED</code> – This component version has been discontinued by its publisher. You can deploy
     *        this component version, but we recommend that you use a different version of this component.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>DELETED</code> – This component version has been deleted by its publisher, so you can't deploy it.
     *        If you have any existing deployments that specify this component version, those deployments will fail.
     *        </p>
     *        </li>
     * @see VendorGuidance
     */

    public void setVendorGuidance(String vendorGuidance) {
        this.vendorGuidance = vendorGuidance;
    }

    /**
     * <p>
     * The vendor guidance state for the component version. This state indicates whether the component version has any
     * issues that you should consider before you deploy it. The vendor guidance state can be:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code> – This component version is available and recommended for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISCONTINUED</code> – This component version has been discontinued by its publisher. You can deploy this
     * component version, but we recommend that you use a different version of this component.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code> – This component version has been deleted by its publisher, so you can't deploy it. If you
     * have any existing deployments that specify this component version, those deployments will fail.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The vendor guidance state for the component version. This state indicates whether the component version
     *         has any issues that you should consider before you deploy it. The vendor guidance state can be:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> – This component version is available and recommended for use.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISCONTINUED</code> – This component version has been discontinued by its publisher. You can deploy
     *         this component version, but we recommend that you use a different version of this component.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETED</code> – This component version has been deleted by its publisher, so you can't deploy it.
     *         If you have any existing deployments that specify this component version, those deployments will fail.
     *         </p>
     *         </li>
     * @see VendorGuidance
     */

    public String getVendorGuidance() {
        return this.vendorGuidance;
    }

    /**
     * <p>
     * The vendor guidance state for the component version. This state indicates whether the component version has any
     * issues that you should consider before you deploy it. The vendor guidance state can be:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code> – This component version is available and recommended for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISCONTINUED</code> – This component version has been discontinued by its publisher. You can deploy this
     * component version, but we recommend that you use a different version of this component.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code> – This component version has been deleted by its publisher, so you can't deploy it. If you
     * have any existing deployments that specify this component version, those deployments will fail.
     * </p>
     * </li>
     * </ul>
     * 
     * @param vendorGuidance
     *        The vendor guidance state for the component version. This state indicates whether the component version
     *        has any issues that you should consider before you deploy it. The vendor guidance state can be:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>ACTIVE</code> – This component version is available and recommended for use.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>DISCONTINUED</code> – This component version has been discontinued by its publisher. You can deploy
     *        this component version, but we recommend that you use a different version of this component.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>DELETED</code> – This component version has been deleted by its publisher, so you can't deploy it.
     *        If you have any existing deployments that specify this component version, those deployments will fail.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see VendorGuidance
     */

    public ResolvedComponentVersion withVendorGuidance(String vendorGuidance) {
        setVendorGuidance(vendorGuidance);
        return this;
    }

    /**
     * <p>
     * The vendor guidance state for the component version. This state indicates whether the component version has any
     * issues that you should consider before you deploy it. The vendor guidance state can be:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code> – This component version is available and recommended for use.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISCONTINUED</code> – This component version has been discontinued by its publisher. You can deploy this
     * component version, but we recommend that you use a different version of this component.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code> – This component version has been deleted by its publisher, so you can't deploy it. If you
     * have any existing deployments that specify this component version, those deployments will fail.
     * </p>
     * </li>
     * </ul>
     * 
     * @param vendorGuidance
     *        The vendor guidance state for the component version. This state indicates whether the component version
     *        has any issues that you should consider before you deploy it. The vendor guidance state can be:</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>ACTIVE</code> – This component version is available and recommended for use.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>DISCONTINUED</code> – This component version has been discontinued by its publisher. You can deploy
     *        this component version, but we recommend that you use a different version of this component.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        <code>DELETED</code> – This component version has been deleted by its publisher, so you can't deploy it.
     *        If you have any existing deployments that specify this component version, those deployments will fail.
     *        </p>
     *        </li>
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see VendorGuidance
     */

    public ResolvedComponentVersion withVendorGuidance(VendorGuidance vendorGuidance) {
        this.vendorGuidance = vendorGuidance.toString();
        return this;
    }

    /**
     * <p>
     * A message that communicates details about the vendor guidance state of the component version. This message
     * communicates why a component version is discontinued or deleted.
     * </p>
     * 
     * @param message
     *        A message that communicates details about the vendor guidance state of the component version. This message
     *        communicates why a component version is discontinued or deleted.
     */

    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * <p>
     * A message that communicates details about the vendor guidance state of the component version. This message
     * communicates why a component version is discontinued or deleted.
     * </p>
     * 
     * @return A message that communicates details about the vendor guidance state of the component version. This
     *         message communicates why a component version is discontinued or deleted.
     */

    public String getMessage() {
        return this.message;
    }

    /**
     * <p>
     * A message that communicates details about the vendor guidance state of the component version. This message
     * communicates why a component version is discontinued or deleted.
     * </p>
     * 
     * @param message
     *        A message that communicates details about the vendor guidance state of the component version. This message
     *        communicates why a component version is discontinued or deleted.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ResolvedComponentVersion withMessage(String message) {
        setMessage(message);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getArn() != null)
            sb.append("Arn: ").append(getArn()).append(",");
        if (getComponentName() != null)
            sb.append("ComponentName: ").append(getComponentName()).append(",");
        if (getComponentVersion() != null)
            sb.append("ComponentVersion: ").append(getComponentVersion()).append(",");
        if (getRecipe() != null)
            sb.append("Recipe: ").append(getRecipe()).append(",");
        if (getVendorGuidance() != null)
            sb.append("VendorGuidance: ").append(getVendorGuidance()).append(",");
        if (getMessage() != null)
            sb.append("Message: ").append(getMessage());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ResolvedComponentVersion == false)
            return false;
        ResolvedComponentVersion other = (ResolvedComponentVersion) obj;
        if (other.getArn() == null ^ this.getArn() == null)
            return false;
        if (other.getArn() != null && other.getArn().equals(this.getArn()) == false)
            return false;
        if (other.getComponentName() == null ^ this.getComponentName() == null)
            return false;
        if (other.getComponentName() != null && other.getComponentName().equals(this.getComponentName()) == false)
            return false;
        if (other.getComponentVersion() == null ^ this.getComponentVersion() == null)
            return false;
        if (other.getComponentVersion() != null && other.getComponentVersion().equals(this.getComponentVersion()) == false)
            return false;
        if (other.getRecipe() == null ^ this.getRecipe() == null)
            return false;
        if (other.getRecipe() != null && other.getRecipe().equals(this.getRecipe()) == false)
            return false;
        if (other.getVendorGuidance() == null ^ this.getVendorGuidance() == null)
            return false;
        if (other.getVendorGuidance() != null && other.getVendorGuidance().equals(this.getVendorGuidance()) == false)
            return false;
        if (other.getMessage() == null ^ this.getMessage() == null)
            return false;
        if (other.getMessage() != null && other.getMessage().equals(this.getMessage()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getArn() == null) ? 0 : getArn().hashCode());
        hashCode = prime * hashCode + ((getComponentName() == null) ? 0 : getComponentName().hashCode());
        hashCode = prime * hashCode + ((getComponentVersion() == null) ? 0 : getComponentVersion().hashCode());
        hashCode = prime * hashCode + ((getRecipe() == null) ? 0 : getRecipe().hashCode());
        hashCode = prime * hashCode + ((getVendorGuidance() == null) ? 0 : getVendorGuidance().hashCode());
        hashCode = prime * hashCode + ((getMessage() == null) ? 0 : getMessage().hashCode());
        return hashCode;
    }

    @Override
    public ResolvedComponentVersion clone() {
        try {
            return (ResolvedComponentVersion) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.greengrassv2.model.transform.ResolvedComponentVersionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
