/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.greengrassv2;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.greengrassv2.AWSGreengrassV2;
import com.amazonaws.services.greengrassv2.AWSGreengrassV2ClientBuilder;
import com.amazonaws.services.greengrassv2.model.AWSGreengrassV2Exception;
import com.amazonaws.services.greengrassv2.model.CancelDeploymentRequest;
import com.amazonaws.services.greengrassv2.model.CancelDeploymentResult;
import com.amazonaws.services.greengrassv2.model.CreateComponentVersionRequest;
import com.amazonaws.services.greengrassv2.model.CreateComponentVersionResult;
import com.amazonaws.services.greengrassv2.model.CreateDeploymentRequest;
import com.amazonaws.services.greengrassv2.model.CreateDeploymentResult;
import com.amazonaws.services.greengrassv2.model.DeleteComponentRequest;
import com.amazonaws.services.greengrassv2.model.DeleteComponentResult;
import com.amazonaws.services.greengrassv2.model.DeleteCoreDeviceRequest;
import com.amazonaws.services.greengrassv2.model.DeleteCoreDeviceResult;
import com.amazonaws.services.greengrassv2.model.DescribeComponentRequest;
import com.amazonaws.services.greengrassv2.model.DescribeComponentResult;
import com.amazonaws.services.greengrassv2.model.GetComponentRequest;
import com.amazonaws.services.greengrassv2.model.GetComponentResult;
import com.amazonaws.services.greengrassv2.model.GetComponentVersionArtifactRequest;
import com.amazonaws.services.greengrassv2.model.GetComponentVersionArtifactResult;
import com.amazonaws.services.greengrassv2.model.GetCoreDeviceRequest;
import com.amazonaws.services.greengrassv2.model.GetCoreDeviceResult;
import com.amazonaws.services.greengrassv2.model.GetDeploymentRequest;
import com.amazonaws.services.greengrassv2.model.GetDeploymentResult;
import com.amazonaws.services.greengrassv2.model.ListComponentVersionsRequest;
import com.amazonaws.services.greengrassv2.model.ListComponentVersionsResult;
import com.amazonaws.services.greengrassv2.model.ListComponentsRequest;
import com.amazonaws.services.greengrassv2.model.ListComponentsResult;
import com.amazonaws.services.greengrassv2.model.ListCoreDevicesRequest;
import com.amazonaws.services.greengrassv2.model.ListCoreDevicesResult;
import com.amazonaws.services.greengrassv2.model.ListDeploymentsRequest;
import com.amazonaws.services.greengrassv2.model.ListDeploymentsResult;
import com.amazonaws.services.greengrassv2.model.ListEffectiveDeploymentsRequest;
import com.amazonaws.services.greengrassv2.model.ListEffectiveDeploymentsResult;
import com.amazonaws.services.greengrassv2.model.ListInstalledComponentsRequest;
import com.amazonaws.services.greengrassv2.model.ListInstalledComponentsResult;
import com.amazonaws.services.greengrassv2.model.ListTagsForResourceRequest;
import com.amazonaws.services.greengrassv2.model.ListTagsForResourceResult;
import com.amazonaws.services.greengrassv2.model.ResolveComponentCandidatesRequest;
import com.amazonaws.services.greengrassv2.model.ResolveComponentCandidatesResult;
import com.amazonaws.services.greengrassv2.model.TagResourceRequest;
import com.amazonaws.services.greengrassv2.model.TagResourceResult;
import com.amazonaws.services.greengrassv2.model.UntagResourceRequest;
import com.amazonaws.services.greengrassv2.model.UntagResourceResult;
import com.amazonaws.services.greengrassv2.model.transform.AccessDeniedExceptionUnmarshaller;
import com.amazonaws.services.greengrassv2.model.transform.CancelDeploymentRequestProtocolMarshaller;
import com.amazonaws.services.greengrassv2.model.transform.CancelDeploymentResultJsonUnmarshaller;
import com.amazonaws.services.greengrassv2.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.greengrassv2.model.transform.CreateComponentVersionRequestProtocolMarshaller;
import com.amazonaws.services.greengrassv2.model.transform.CreateComponentVersionResultJsonUnmarshaller;
import com.amazonaws.services.greengrassv2.model.transform.CreateDeploymentRequestProtocolMarshaller;
import com.amazonaws.services.greengrassv2.model.transform.CreateDeploymentResultJsonUnmarshaller;
import com.amazonaws.services.greengrassv2.model.transform.DeleteComponentRequestProtocolMarshaller;
import com.amazonaws.services.greengrassv2.model.transform.DeleteComponentResultJsonUnmarshaller;
import com.amazonaws.services.greengrassv2.model.transform.DeleteCoreDeviceRequestProtocolMarshaller;
import com.amazonaws.services.greengrassv2.model.transform.DeleteCoreDeviceResultJsonUnmarshaller;
import com.amazonaws.services.greengrassv2.model.transform.DescribeComponentRequestProtocolMarshaller;
import com.amazonaws.services.greengrassv2.model.transform.DescribeComponentResultJsonUnmarshaller;
import com.amazonaws.services.greengrassv2.model.transform.GetComponentRequestProtocolMarshaller;
import com.amazonaws.services.greengrassv2.model.transform.GetComponentResultJsonUnmarshaller;
import com.amazonaws.services.greengrassv2.model.transform.GetComponentVersionArtifactRequestProtocolMarshaller;
import com.amazonaws.services.greengrassv2.model.transform.GetComponentVersionArtifactResultJsonUnmarshaller;
import com.amazonaws.services.greengrassv2.model.transform.GetCoreDeviceRequestProtocolMarshaller;
import com.amazonaws.services.greengrassv2.model.transform.GetCoreDeviceResultJsonUnmarshaller;
import com.amazonaws.services.greengrassv2.model.transform.GetDeploymentRequestProtocolMarshaller;
import com.amazonaws.services.greengrassv2.model.transform.GetDeploymentResultJsonUnmarshaller;
import com.amazonaws.services.greengrassv2.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.greengrassv2.model.transform.ListComponentVersionsRequestProtocolMarshaller;
import com.amazonaws.services.greengrassv2.model.transform.ListComponentVersionsResultJsonUnmarshaller;
import com.amazonaws.services.greengrassv2.model.transform.ListComponentsRequestProtocolMarshaller;
import com.amazonaws.services.greengrassv2.model.transform.ListComponentsResultJsonUnmarshaller;
import com.amazonaws.services.greengrassv2.model.transform.ListCoreDevicesRequestProtocolMarshaller;
import com.amazonaws.services.greengrassv2.model.transform.ListCoreDevicesResultJsonUnmarshaller;
import com.amazonaws.services.greengrassv2.model.transform.ListDeploymentsRequestProtocolMarshaller;
import com.amazonaws.services.greengrassv2.model.transform.ListDeploymentsResultJsonUnmarshaller;
import com.amazonaws.services.greengrassv2.model.transform.ListEffectiveDeploymentsRequestProtocolMarshaller;
import com.amazonaws.services.greengrassv2.model.transform.ListEffectiveDeploymentsResultJsonUnmarshaller;
import com.amazonaws.services.greengrassv2.model.transform.ListInstalledComponentsRequestProtocolMarshaller;
import com.amazonaws.services.greengrassv2.model.transform.ListInstalledComponentsResultJsonUnmarshaller;
import com.amazonaws.services.greengrassv2.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.greengrassv2.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.greengrassv2.model.transform.ResolveComponentCandidatesRequestProtocolMarshaller;
import com.amazonaws.services.greengrassv2.model.transform.ResolveComponentCandidatesResultJsonUnmarshaller;
import com.amazonaws.services.greengrassv2.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.greengrassv2.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.greengrassv2.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.greengrassv2.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.greengrassv2.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.greengrassv2.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.greengrassv2.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.greengrassv2.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AWSGreengrassV2Client
extends AmazonWebServiceClient
implements AWSGreengrassV2 {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AWSGreengrassV2.class);
    private static final String DEFAULT_SIGNING_NAME = "greengrass";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("AccessDeniedException").withExceptionUnmarshaller((JsonErrorUnmarshaller)AccessDeniedExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AWSGreengrassV2Exception.class));

    public static AWSGreengrassV2ClientBuilder builder() {
        return AWSGreengrassV2ClientBuilder.standard();
    }

    AWSGreengrassV2Client(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AWSGreengrassV2Client(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("greengrass.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/greengrassv2/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/greengrassv2/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public CancelDeploymentResult cancelDeployment(CancelDeploymentRequest request) {
        request = (CancelDeploymentRequest)this.beforeClientExecution(request);
        return this.executeCancelDeployment(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CancelDeploymentResult executeCancelDeployment(CancelDeploymentRequest cancelDeploymentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(cancelDeploymentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CancelDeploymentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CancelDeploymentRequestProtocolMarshaller(protocolFactory).marshall((CancelDeploymentRequest)super.beforeMarshalling((AmazonWebServiceRequest)cancelDeploymentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GreengrassV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CancelDeployment");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CancelDeploymentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CancelDeploymentResult cancelDeploymentResult = (CancelDeploymentResult)response.getAwsResponse();
            return cancelDeploymentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateComponentVersionResult createComponentVersion(CreateComponentVersionRequest request) {
        request = (CreateComponentVersionRequest)this.beforeClientExecution(request);
        return this.executeCreateComponentVersion(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateComponentVersionResult executeCreateComponentVersion(CreateComponentVersionRequest createComponentVersionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createComponentVersionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateComponentVersionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateComponentVersionRequestProtocolMarshaller(protocolFactory).marshall((CreateComponentVersionRequest)super.beforeMarshalling((AmazonWebServiceRequest)createComponentVersionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GreengrassV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateComponentVersion");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateComponentVersionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateComponentVersionResult createComponentVersionResult = (CreateComponentVersionResult)response.getAwsResponse();
            return createComponentVersionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateDeploymentResult createDeployment(CreateDeploymentRequest request) {
        request = (CreateDeploymentRequest)this.beforeClientExecution(request);
        return this.executeCreateDeployment(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateDeploymentResult executeCreateDeployment(CreateDeploymentRequest createDeploymentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createDeploymentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateDeploymentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateDeploymentRequestProtocolMarshaller(protocolFactory).marshall((CreateDeploymentRequest)super.beforeMarshalling((AmazonWebServiceRequest)createDeploymentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GreengrassV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateDeployment");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateDeploymentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateDeploymentResult createDeploymentResult = (CreateDeploymentResult)response.getAwsResponse();
            return createDeploymentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteComponentResult deleteComponent(DeleteComponentRequest request) {
        request = (DeleteComponentRequest)this.beforeClientExecution(request);
        return this.executeDeleteComponent(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteComponentResult executeDeleteComponent(DeleteComponentRequest deleteComponentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteComponentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteComponentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteComponentRequestProtocolMarshaller(protocolFactory).marshall((DeleteComponentRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteComponentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GreengrassV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteComponent");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteComponentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteComponentResult deleteComponentResult = (DeleteComponentResult)response.getAwsResponse();
            return deleteComponentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteCoreDeviceResult deleteCoreDevice(DeleteCoreDeviceRequest request) {
        request = (DeleteCoreDeviceRequest)this.beforeClientExecution(request);
        return this.executeDeleteCoreDevice(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteCoreDeviceResult executeDeleteCoreDevice(DeleteCoreDeviceRequest deleteCoreDeviceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteCoreDeviceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteCoreDeviceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteCoreDeviceRequestProtocolMarshaller(protocolFactory).marshall((DeleteCoreDeviceRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteCoreDeviceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GreengrassV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteCoreDevice");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteCoreDeviceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteCoreDeviceResult deleteCoreDeviceResult = (DeleteCoreDeviceResult)response.getAwsResponse();
            return deleteCoreDeviceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeComponentResult describeComponent(DescribeComponentRequest request) {
        request = (DescribeComponentRequest)this.beforeClientExecution(request);
        return this.executeDescribeComponent(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeComponentResult executeDescribeComponent(DescribeComponentRequest describeComponentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeComponentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeComponentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeComponentRequestProtocolMarshaller(protocolFactory).marshall((DescribeComponentRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeComponentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GreengrassV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeComponent");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeComponentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeComponentResult describeComponentResult = (DescribeComponentResult)response.getAwsResponse();
            return describeComponentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetComponentResult getComponent(GetComponentRequest request) {
        request = (GetComponentRequest)this.beforeClientExecution(request);
        return this.executeGetComponent(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetComponentResult executeGetComponent(GetComponentRequest getComponentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getComponentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetComponentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetComponentRequestProtocolMarshaller(protocolFactory).marshall((GetComponentRequest)super.beforeMarshalling((AmazonWebServiceRequest)getComponentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GreengrassV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetComponent");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetComponentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetComponentResult getComponentResult = (GetComponentResult)response.getAwsResponse();
            return getComponentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetComponentVersionArtifactResult getComponentVersionArtifact(GetComponentVersionArtifactRequest request) {
        request = (GetComponentVersionArtifactRequest)this.beforeClientExecution(request);
        return this.executeGetComponentVersionArtifact(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetComponentVersionArtifactResult executeGetComponentVersionArtifact(GetComponentVersionArtifactRequest getComponentVersionArtifactRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getComponentVersionArtifactRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetComponentVersionArtifactRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetComponentVersionArtifactRequestProtocolMarshaller(protocolFactory).marshall((GetComponentVersionArtifactRequest)super.beforeMarshalling((AmazonWebServiceRequest)getComponentVersionArtifactRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GreengrassV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetComponentVersionArtifact");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetComponentVersionArtifactResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetComponentVersionArtifactResult getComponentVersionArtifactResult = (GetComponentVersionArtifactResult)response.getAwsResponse();
            return getComponentVersionArtifactResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetCoreDeviceResult getCoreDevice(GetCoreDeviceRequest request) {
        request = (GetCoreDeviceRequest)this.beforeClientExecution(request);
        return this.executeGetCoreDevice(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetCoreDeviceResult executeGetCoreDevice(GetCoreDeviceRequest getCoreDeviceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getCoreDeviceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetCoreDeviceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetCoreDeviceRequestProtocolMarshaller(protocolFactory).marshall((GetCoreDeviceRequest)super.beforeMarshalling((AmazonWebServiceRequest)getCoreDeviceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GreengrassV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetCoreDevice");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetCoreDeviceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetCoreDeviceResult getCoreDeviceResult = (GetCoreDeviceResult)response.getAwsResponse();
            return getCoreDeviceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public GetDeploymentResult getDeployment(GetDeploymentRequest request) {
        request = (GetDeploymentRequest)this.beforeClientExecution(request);
        return this.executeGetDeployment(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final GetDeploymentResult executeGetDeployment(GetDeploymentRequest getDeploymentRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDeploymentRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDeploymentRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDeploymentRequestProtocolMarshaller(protocolFactory).marshall((GetDeploymentRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDeploymentRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GreengrassV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetDeployment");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDeploymentResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDeploymentResult getDeploymentResult = (GetDeploymentResult)response.getAwsResponse();
            return getDeploymentResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListComponentVersionsResult listComponentVersions(ListComponentVersionsRequest request) {
        request = (ListComponentVersionsRequest)this.beforeClientExecution(request);
        return this.executeListComponentVersions(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListComponentVersionsResult executeListComponentVersions(ListComponentVersionsRequest listComponentVersionsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listComponentVersionsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListComponentVersionsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListComponentVersionsRequestProtocolMarshaller(protocolFactory).marshall((ListComponentVersionsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listComponentVersionsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GreengrassV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListComponentVersions");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListComponentVersionsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListComponentVersionsResult listComponentVersionsResult = (ListComponentVersionsResult)response.getAwsResponse();
            return listComponentVersionsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListComponentsResult listComponents(ListComponentsRequest request) {
        request = (ListComponentsRequest)this.beforeClientExecution(request);
        return this.executeListComponents(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListComponentsResult executeListComponents(ListComponentsRequest listComponentsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listComponentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListComponentsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListComponentsRequestProtocolMarshaller(protocolFactory).marshall((ListComponentsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listComponentsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GreengrassV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListComponents");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListComponentsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListComponentsResult listComponentsResult = (ListComponentsResult)response.getAwsResponse();
            return listComponentsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListCoreDevicesResult listCoreDevices(ListCoreDevicesRequest request) {
        request = (ListCoreDevicesRequest)this.beforeClientExecution(request);
        return this.executeListCoreDevices(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListCoreDevicesResult executeListCoreDevices(ListCoreDevicesRequest listCoreDevicesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listCoreDevicesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListCoreDevicesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListCoreDevicesRequestProtocolMarshaller(protocolFactory).marshall((ListCoreDevicesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listCoreDevicesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GreengrassV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListCoreDevices");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListCoreDevicesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListCoreDevicesResult listCoreDevicesResult = (ListCoreDevicesResult)response.getAwsResponse();
            return listCoreDevicesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListDeploymentsResult listDeployments(ListDeploymentsRequest request) {
        request = (ListDeploymentsRequest)this.beforeClientExecution(request);
        return this.executeListDeployments(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListDeploymentsResult executeListDeployments(ListDeploymentsRequest listDeploymentsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listDeploymentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListDeploymentsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListDeploymentsRequestProtocolMarshaller(protocolFactory).marshall((ListDeploymentsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listDeploymentsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GreengrassV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListDeployments");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListDeploymentsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListDeploymentsResult listDeploymentsResult = (ListDeploymentsResult)response.getAwsResponse();
            return listDeploymentsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListEffectiveDeploymentsResult listEffectiveDeployments(ListEffectiveDeploymentsRequest request) {
        request = (ListEffectiveDeploymentsRequest)this.beforeClientExecution(request);
        return this.executeListEffectiveDeployments(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListEffectiveDeploymentsResult executeListEffectiveDeployments(ListEffectiveDeploymentsRequest listEffectiveDeploymentsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listEffectiveDeploymentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListEffectiveDeploymentsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListEffectiveDeploymentsRequestProtocolMarshaller(protocolFactory).marshall((ListEffectiveDeploymentsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listEffectiveDeploymentsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GreengrassV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListEffectiveDeployments");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListEffectiveDeploymentsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListEffectiveDeploymentsResult listEffectiveDeploymentsResult = (ListEffectiveDeploymentsResult)response.getAwsResponse();
            return listEffectiveDeploymentsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListInstalledComponentsResult listInstalledComponents(ListInstalledComponentsRequest request) {
        request = (ListInstalledComponentsRequest)this.beforeClientExecution(request);
        return this.executeListInstalledComponents(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListInstalledComponentsResult executeListInstalledComponents(ListInstalledComponentsRequest listInstalledComponentsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listInstalledComponentsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListInstalledComponentsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListInstalledComponentsRequestProtocolMarshaller(protocolFactory).marshall((ListInstalledComponentsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listInstalledComponentsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GreengrassV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListInstalledComponents");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListInstalledComponentsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListInstalledComponentsResult listInstalledComponentsResult = (ListInstalledComponentsResult)response.getAwsResponse();
            return listInstalledComponentsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GreengrassV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResolveComponentCandidatesResult resolveComponentCandidates(ResolveComponentCandidatesRequest request) {
        request = (ResolveComponentCandidatesRequest)this.beforeClientExecution(request);
        return this.executeResolveComponentCandidates(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ResolveComponentCandidatesResult executeResolveComponentCandidates(ResolveComponentCandidatesRequest resolveComponentCandidatesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(resolveComponentCandidatesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ResolveComponentCandidatesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ResolveComponentCandidatesRequestProtocolMarshaller(protocolFactory).marshall((ResolveComponentCandidatesRequest)super.beforeMarshalling((AmazonWebServiceRequest)resolveComponentCandidatesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GreengrassV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ResolveComponentCandidates");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ResolveComponentCandidatesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ResolveComponentCandidatesResult resolveComponentCandidatesResult = (ResolveComponentCandidatesResult)response.getAwsResponse();
            return resolveComponentCandidatesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GreengrassV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"GreengrassV2");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

