/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.greengrass.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.greengrass.model.ResourceAccessPolicy;
import com.amazonaws.services.greengrass.model.transform.FunctionConfigurationEnvironmentMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FunctionConfigurationEnvironment
implements Serializable,
Cloneable,
StructuredPojo {
    private Boolean accessSysfs;
    private List<ResourceAccessPolicy> resourceAccessPolicies;
    private Map<String, String> variables;

    public void setAccessSysfs(Boolean accessSysfs) {
        this.accessSysfs = accessSysfs;
    }

    public Boolean getAccessSysfs() {
        return this.accessSysfs;
    }

    public FunctionConfigurationEnvironment withAccessSysfs(Boolean accessSysfs) {
        this.setAccessSysfs(accessSysfs);
        return this;
    }

    public Boolean isAccessSysfs() {
        return this.accessSysfs;
    }

    public List<ResourceAccessPolicy> getResourceAccessPolicies() {
        return this.resourceAccessPolicies;
    }

    public void setResourceAccessPolicies(Collection<ResourceAccessPolicy> resourceAccessPolicies) {
        if (resourceAccessPolicies == null) {
            this.resourceAccessPolicies = null;
            return;
        }
        this.resourceAccessPolicies = new ArrayList<ResourceAccessPolicy>(resourceAccessPolicies);
    }

    public FunctionConfigurationEnvironment withResourceAccessPolicies(ResourceAccessPolicy ... resourceAccessPolicies) {
        if (this.resourceAccessPolicies == null) {
            this.setResourceAccessPolicies(new ArrayList<ResourceAccessPolicy>(resourceAccessPolicies.length));
        }
        for (ResourceAccessPolicy ele : resourceAccessPolicies) {
            this.resourceAccessPolicies.add(ele);
        }
        return this;
    }

    public FunctionConfigurationEnvironment withResourceAccessPolicies(Collection<ResourceAccessPolicy> resourceAccessPolicies) {
        this.setResourceAccessPolicies(resourceAccessPolicies);
        return this;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public void setVariables(Map<String, String> variables) {
        this.variables = variables;
    }

    public FunctionConfigurationEnvironment withVariables(Map<String, String> variables) {
        this.setVariables(variables);
        return this;
    }

    public FunctionConfigurationEnvironment addVariablesEntry(String key, String value) {
        if (null == this.variables) {
            this.variables = new HashMap<String, String>();
        }
        if (this.variables.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.variables.put(key, value);
        return this;
    }

    public FunctionConfigurationEnvironment clearVariablesEntries() {
        this.variables = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccessSysfs() != null) {
            sb.append("AccessSysfs: ").append(this.getAccessSysfs()).append(",");
        }
        if (this.getResourceAccessPolicies() != null) {
            sb.append("ResourceAccessPolicies: ").append(this.getResourceAccessPolicies()).append(",");
        }
        if (this.getVariables() != null) {
            sb.append("Variables: ").append(this.getVariables());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FunctionConfigurationEnvironment)) {
            return false;
        }
        FunctionConfigurationEnvironment other = (FunctionConfigurationEnvironment)obj;
        if (other.getAccessSysfs() == null ^ this.getAccessSysfs() == null) {
            return false;
        }
        if (other.getAccessSysfs() != null && !other.getAccessSysfs().equals(this.getAccessSysfs())) {
            return false;
        }
        if (other.getResourceAccessPolicies() == null ^ this.getResourceAccessPolicies() == null) {
            return false;
        }
        if (other.getResourceAccessPolicies() != null && !other.getResourceAccessPolicies().equals(this.getResourceAccessPolicies())) {
            return false;
        }
        if (other.getVariables() == null ^ this.getVariables() == null) {
            return false;
        }
        return other.getVariables() == null || other.getVariables().equals(this.getVariables());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccessSysfs() == null ? 0 : this.getAccessSysfs().hashCode());
        hashCode = 31 * hashCode + (this.getResourceAccessPolicies() == null ? 0 : this.getResourceAccessPolicies().hashCode());
        hashCode = 31 * hashCode + (this.getVariables() == null ? 0 : this.getVariables().hashCode());
        return hashCode;
    }

    public FunctionConfigurationEnvironment clone() {
        try {
            return (FunctionConfigurationEnvironment)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FunctionConfigurationEnvironmentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

