/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gluedatabrew.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.gluedatabrew.model.FormatOptions;
import com.amazonaws.services.gluedatabrew.model.Input;
import com.amazonaws.services.gluedatabrew.model.InputFormat;
import com.amazonaws.services.gluedatabrew.model.PathOptions;
import com.amazonaws.services.gluedatabrew.model.Source;
import com.amazonaws.services.gluedatabrew.model.transform.DatasetMarshaller;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Dataset
implements Serializable,
Cloneable,
StructuredPojo {
    private String accountId;
    private String createdBy;
    private Date createDate;
    private String name;
    private String format;
    private FormatOptions formatOptions;
    private Input input;
    private Date lastModifiedDate;
    private String lastModifiedBy;
    private String source;
    private PathOptions pathOptions;
    private Map<String, String> tags;
    private String resourceArn;

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public Dataset withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public Dataset withCreatedBy(String createdBy) {
        this.setCreatedBy(createdBy);
        return this;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public Dataset withCreateDate(Date createDate) {
        this.setCreateDate(createDate);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Dataset withName(String name) {
        this.setName(name);
        return this;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public Dataset withFormat(String format) {
        this.setFormat(format);
        return this;
    }

    public Dataset withFormat(InputFormat format) {
        this.format = format.toString();
        return this;
    }

    public void setFormatOptions(FormatOptions formatOptions) {
        this.formatOptions = formatOptions;
    }

    public FormatOptions getFormatOptions() {
        return this.formatOptions;
    }

    public Dataset withFormatOptions(FormatOptions formatOptions) {
        this.setFormatOptions(formatOptions);
        return this;
    }

    public void setInput(Input input) {
        this.input = input;
    }

    public Input getInput() {
        return this.input;
    }

    public Dataset withInput(Input input) {
        this.setInput(input);
        return this;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Dataset withLastModifiedDate(Date lastModifiedDate) {
        this.setLastModifiedDate(lastModifiedDate);
        return this;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public Dataset withLastModifiedBy(String lastModifiedBy) {
        this.setLastModifiedBy(lastModifiedBy);
        return this;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public Dataset withSource(String source) {
        this.setSource(source);
        return this;
    }

    public Dataset withSource(Source source) {
        this.source = source.toString();
        return this;
    }

    public void setPathOptions(PathOptions pathOptions) {
        this.pathOptions = pathOptions;
    }

    public PathOptions getPathOptions() {
        return this.pathOptions;
    }

    public Dataset withPathOptions(PathOptions pathOptions) {
        this.setPathOptions(pathOptions);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Dataset withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public Dataset addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public Dataset clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setResourceArn(String resourceArn) {
        this.resourceArn = resourceArn;
    }

    public String getResourceArn() {
        return this.resourceArn;
    }

    public Dataset withResourceArn(String resourceArn) {
        this.setResourceArn(resourceArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccountId() != null) {
            sb.append("AccountId: ").append(this.getAccountId()).append(",");
        }
        if (this.getCreatedBy() != null) {
            sb.append("CreatedBy: ").append(this.getCreatedBy()).append(",");
        }
        if (this.getCreateDate() != null) {
            sb.append("CreateDate: ").append(this.getCreateDate()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getFormat() != null) {
            sb.append("Format: ").append(this.getFormat()).append(",");
        }
        if (this.getFormatOptions() != null) {
            sb.append("FormatOptions: ").append(this.getFormatOptions()).append(",");
        }
        if (this.getInput() != null) {
            sb.append("Input: ").append(this.getInput()).append(",");
        }
        if (this.getLastModifiedDate() != null) {
            sb.append("LastModifiedDate: ").append(this.getLastModifiedDate()).append(",");
        }
        if (this.getLastModifiedBy() != null) {
            sb.append("LastModifiedBy: ").append(this.getLastModifiedBy()).append(",");
        }
        if (this.getSource() != null) {
            sb.append("Source: ").append(this.getSource()).append(",");
        }
        if (this.getPathOptions() != null) {
            sb.append("PathOptions: ").append(this.getPathOptions()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getResourceArn() != null) {
            sb.append("ResourceArn: ").append(this.getResourceArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Dataset)) {
            return false;
        }
        Dataset other = (Dataset)obj;
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getCreatedBy() == null ^ this.getCreatedBy() == null) {
            return false;
        }
        if (other.getCreatedBy() != null && !other.getCreatedBy().equals(this.getCreatedBy())) {
            return false;
        }
        if (other.getCreateDate() == null ^ this.getCreateDate() == null) {
            return false;
        }
        if (other.getCreateDate() != null && !other.getCreateDate().equals(this.getCreateDate())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getFormat() == null ^ this.getFormat() == null) {
            return false;
        }
        if (other.getFormat() != null && !other.getFormat().equals(this.getFormat())) {
            return false;
        }
        if (other.getFormatOptions() == null ^ this.getFormatOptions() == null) {
            return false;
        }
        if (other.getFormatOptions() != null && !other.getFormatOptions().equals(this.getFormatOptions())) {
            return false;
        }
        if (other.getInput() == null ^ this.getInput() == null) {
            return false;
        }
        if (other.getInput() != null && !other.getInput().equals(this.getInput())) {
            return false;
        }
        if (other.getLastModifiedDate() == null ^ this.getLastModifiedDate() == null) {
            return false;
        }
        if (other.getLastModifiedDate() != null && !other.getLastModifiedDate().equals(this.getLastModifiedDate())) {
            return false;
        }
        if (other.getLastModifiedBy() == null ^ this.getLastModifiedBy() == null) {
            return false;
        }
        if (other.getLastModifiedBy() != null && !other.getLastModifiedBy().equals(this.getLastModifiedBy())) {
            return false;
        }
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        if (other.getSource() != null && !other.getSource().equals(this.getSource())) {
            return false;
        }
        if (other.getPathOptions() == null ^ this.getPathOptions() == null) {
            return false;
        }
        if (other.getPathOptions() != null && !other.getPathOptions().equals(this.getPathOptions())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getResourceArn() == null ^ this.getResourceArn() == null) {
            return false;
        }
        return other.getResourceArn() == null || other.getResourceArn().equals(this.getResourceArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedBy() == null ? 0 : this.getCreatedBy().hashCode());
        hashCode = 31 * hashCode + (this.getCreateDate() == null ? 0 : this.getCreateDate().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getFormat() == null ? 0 : this.getFormat().hashCode());
        hashCode = 31 * hashCode + (this.getFormatOptions() == null ? 0 : this.getFormatOptions().hashCode());
        hashCode = 31 * hashCode + (this.getInput() == null ? 0 : this.getInput().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedDate() == null ? 0 : this.getLastModifiedDate().hashCode());
        hashCode = 31 * hashCode + (this.getLastModifiedBy() == null ? 0 : this.getLastModifiedBy().hashCode());
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        hashCode = 31 * hashCode + (this.getPathOptions() == null ? 0 : this.getPathOptions().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getResourceArn() == null ? 0 : this.getResourceArn().hashCode());
        return hashCode;
    }

    public Dataset clone() {
        try {
            return (Dataset)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DatasetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

