/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gluedatabrew.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.gluedatabrew.model.transform.StatisticOverrideMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class StatisticOverride
implements Serializable,
Cloneable,
StructuredPojo {
    private String statistic;
    private Map<String, String> parameters;

    public void setStatistic(String statistic) {
        this.statistic = statistic;
    }

    public String getStatistic() {
        return this.statistic;
    }

    public StatisticOverride withStatistic(String statistic) {
        this.setStatistic(statistic);
        return this;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public StatisticOverride withParameters(Map<String, String> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public StatisticOverride addParametersEntry(String key, String value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, String>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public StatisticOverride clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStatistic() != null) {
            sb.append("Statistic: ").append(this.getStatistic()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatisticOverride)) {
            return false;
        }
        StatisticOverride other = (StatisticOverride)obj;
        if (other.getStatistic() == null ^ this.getStatistic() == null) {
            return false;
        }
        if (other.getStatistic() != null && !other.getStatistic().equals(this.getStatistic())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        return other.getParameters() == null || other.getParameters().equals(this.getParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStatistic() == null ? 0 : this.getStatistic().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        return hashCode;
    }

    public StatisticOverride clone() {
        try {
            return (StatisticOverride)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StatisticOverrideMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

