/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gluedatabrew.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.gluedatabrew.model.JobRun;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class JobRunMarshaller {
    private static final MarshallingInfo<Integer> ATTEMPT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Attempt").build();
    private static final MarshallingInfo<Date> COMPLETEDON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompletedOn").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> DATASETNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatasetName").build();
    private static final MarshallingInfo<String> ERRORMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorMessage").build();
    private static final MarshallingInfo<Integer> EXECUTIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExecutionTime").build();
    private static final MarshallingInfo<String> JOBNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobName").build();
    private static final MarshallingInfo<String> RUNID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RunId").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<String> LOGSUBSCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogSubscription").build();
    private static final MarshallingInfo<String> LOGGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogGroupName").build();
    private static final MarshallingInfo<List> OUTPUTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Outputs").build();
    private static final MarshallingInfo<StructuredPojo> RECIPEREFERENCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecipeReference").build();
    private static final MarshallingInfo<String> STARTEDBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartedBy").build();
    private static final MarshallingInfo<Date> STARTEDON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartedOn").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<StructuredPojo> JOBSAMPLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobSample").build();
    private static final JobRunMarshaller instance = new JobRunMarshaller();

    public static JobRunMarshaller getInstance() {
        return instance;
    }

    public void marshall(JobRun jobRun, ProtocolMarshaller protocolMarshaller) {
        if (jobRun == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)jobRun.getAttempt(), ATTEMPT_BINDING);
            protocolMarshaller.marshall((Object)jobRun.getCompletedOn(), COMPLETEDON_BINDING);
            protocolMarshaller.marshall((Object)jobRun.getDatasetName(), DATASETNAME_BINDING);
            protocolMarshaller.marshall((Object)jobRun.getErrorMessage(), ERRORMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)jobRun.getExecutionTime(), EXECUTIONTIME_BINDING);
            protocolMarshaller.marshall((Object)jobRun.getJobName(), JOBNAME_BINDING);
            protocolMarshaller.marshall((Object)jobRun.getRunId(), RUNID_BINDING);
            protocolMarshaller.marshall((Object)jobRun.getState(), STATE_BINDING);
            protocolMarshaller.marshall((Object)jobRun.getLogSubscription(), LOGSUBSCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)jobRun.getLogGroupName(), LOGGROUPNAME_BINDING);
            protocolMarshaller.marshall(jobRun.getOutputs(), OUTPUTS_BINDING);
            protocolMarshaller.marshall((Object)jobRun.getRecipeReference(), RECIPEREFERENCE_BINDING);
            protocolMarshaller.marshall((Object)jobRun.getStartedBy(), STARTEDBY_BINDING);
            protocolMarshaller.marshall((Object)jobRun.getStartedOn(), STARTEDON_BINDING);
            protocolMarshaller.marshall((Object)jobRun.getJobSample(), JOBSAMPLE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

