/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model.transform;

import com.amazonaws.services.glue.model.S3JsonSource;
import com.amazonaws.services.glue.model.transform.GlueSchemaJsonUnmarshaller;
import com.amazonaws.services.glue.model.transform.S3DirectSourceAdditionalOptionsJsonUnmarshaller;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class S3JsonSourceJsonUnmarshaller
implements Unmarshaller<S3JsonSource, JsonUnmarshallerContext> {
    private static S3JsonSourceJsonUnmarshaller instance;

    public S3JsonSource unmarshall(JsonUnmarshallerContext context) throws Exception {
        S3JsonSource s3JsonSource = new S3JsonSource();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    s3JsonSource.setName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Paths", targetDepth)) {
                    context.nextToken();
                    s3JsonSource.setPaths(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("CompressionType", targetDepth)) {
                    context.nextToken();
                    s3JsonSource.setCompressionType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Exclusions", targetDepth)) {
                    context.nextToken();
                    s3JsonSource.setExclusions(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("GroupSize", targetDepth)) {
                    context.nextToken();
                    s3JsonSource.setGroupSize((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("GroupFiles", targetDepth)) {
                    context.nextToken();
                    s3JsonSource.setGroupFiles((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Recurse", targetDepth)) {
                    context.nextToken();
                    s3JsonSource.setRecurse((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("MaxBand", targetDepth)) {
                    context.nextToken();
                    s3JsonSource.setMaxBand((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("MaxFilesInBand", targetDepth)) {
                    context.nextToken();
                    s3JsonSource.setMaxFilesInBand((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("AdditionalOptions", targetDepth)) {
                    context.nextToken();
                    s3JsonSource.setAdditionalOptions(S3DirectSourceAdditionalOptionsJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("JsonPath", targetDepth)) {
                    context.nextToken();
                    s3JsonSource.setJsonPath((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Multiline", targetDepth)) {
                    context.nextToken();
                    s3JsonSource.setMultiline((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("OutputSchemas", targetDepth)) {
                    context.nextToken();
                    s3JsonSource.setOutputSchemas(new ListUnmarshaller((Unmarshaller)GlueSchemaJsonUnmarshaller.getInstance()).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return s3JsonSource;
    }

    public static S3JsonSourceJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new S3JsonSourceJsonUnmarshaller();
        }
        return instance;
    }
}

