/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.transform.ConfigurationObjectMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ConfigurationObject
implements Serializable,
Cloneable,
StructuredPojo {
    private String defaultValue;
    private List<String> allowedValues;
    private String minValue;
    private String maxValue;

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public ConfigurationObject withDefaultValue(String defaultValue) {
        this.setDefaultValue(defaultValue);
        return this;
    }

    public List<String> getAllowedValues() {
        return this.allowedValues;
    }

    public void setAllowedValues(Collection<String> allowedValues) {
        if (allowedValues == null) {
            this.allowedValues = null;
            return;
        }
        this.allowedValues = new ArrayList<String>(allowedValues);
    }

    public ConfigurationObject withAllowedValues(String ... allowedValues) {
        if (this.allowedValues == null) {
            this.setAllowedValues(new ArrayList<String>(allowedValues.length));
        }
        for (String ele : allowedValues) {
            this.allowedValues.add(ele);
        }
        return this;
    }

    public ConfigurationObject withAllowedValues(Collection<String> allowedValues) {
        this.setAllowedValues(allowedValues);
        return this;
    }

    public void setMinValue(String minValue) {
        this.minValue = minValue;
    }

    public String getMinValue() {
        return this.minValue;
    }

    public ConfigurationObject withMinValue(String minValue) {
        this.setMinValue(minValue);
        return this;
    }

    public void setMaxValue(String maxValue) {
        this.maxValue = maxValue;
    }

    public String getMaxValue() {
        return this.maxValue;
    }

    public ConfigurationObject withMaxValue(String maxValue) {
        this.setMaxValue(maxValue);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDefaultValue() != null) {
            sb.append("DefaultValue: ").append(this.getDefaultValue()).append(",");
        }
        if (this.getAllowedValues() != null) {
            sb.append("AllowedValues: ").append(this.getAllowedValues()).append(",");
        }
        if (this.getMinValue() != null) {
            sb.append("MinValue: ").append(this.getMinValue()).append(",");
        }
        if (this.getMaxValue() != null) {
            sb.append("MaxValue: ").append(this.getMaxValue());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurationObject)) {
            return false;
        }
        ConfigurationObject other = (ConfigurationObject)obj;
        if (other.getDefaultValue() == null ^ this.getDefaultValue() == null) {
            return false;
        }
        if (other.getDefaultValue() != null && !other.getDefaultValue().equals(this.getDefaultValue())) {
            return false;
        }
        if (other.getAllowedValues() == null ^ this.getAllowedValues() == null) {
            return false;
        }
        if (other.getAllowedValues() != null && !other.getAllowedValues().equals(this.getAllowedValues())) {
            return false;
        }
        if (other.getMinValue() == null ^ this.getMinValue() == null) {
            return false;
        }
        if (other.getMinValue() != null && !other.getMinValue().equals(this.getMinValue())) {
            return false;
        }
        if (other.getMaxValue() == null ^ this.getMaxValue() == null) {
            return false;
        }
        return other.getMaxValue() == null || other.getMaxValue().equals(this.getMaxValue());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDefaultValue() == null ? 0 : this.getDefaultValue().hashCode());
        hashCode = 31 * hashCode + (this.getAllowedValues() == null ? 0 : this.getAllowedValues().hashCode());
        hashCode = 31 * hashCode + (this.getMinValue() == null ? 0 : this.getMinValue().hashCode());
        hashCode = 31 * hashCode + (this.getMaxValue() == null ? 0 : this.getMaxValue().hashCode());
        return hashCode;
    }

    public ConfigurationObject clone() {
        try {
            return (ConfigurationObject)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConfigurationObjectMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

