/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.ConnectionsList;
import com.amazonaws.services.glue.model.SessionCommand;
import com.amazonaws.services.glue.model.SessionStatus;
import com.amazonaws.services.glue.model.WorkerType;
import com.amazonaws.services.glue.model.transform.SessionMarshaller;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Session
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private Date createdOn;
    private String status;
    private String errorMessage;
    private String description;
    private String role;
    private SessionCommand command;
    private Map<String, String> defaultArguments;
    private ConnectionsList connections;
    private Double progress;
    private Double maxCapacity;
    private String securityConfiguration;
    private String glueVersion;
    private Integer numberOfWorkers;
    private String workerType;
    private Date completedOn;
    private Double executionTime;
    private Double dPUSeconds;
    private Integer idleTimeout;
    private String profileName;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public Session withId(String id) {
        this.setId(id);
        return this;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public Session withCreatedOn(Date createdOn) {
        this.setCreatedOn(createdOn);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Session withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public Session withStatus(SessionStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Session withErrorMessage(String errorMessage) {
        this.setErrorMessage(errorMessage);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Session withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getRole() {
        return this.role;
    }

    public Session withRole(String role) {
        this.setRole(role);
        return this;
    }

    public void setCommand(SessionCommand command) {
        this.command = command;
    }

    public SessionCommand getCommand() {
        return this.command;
    }

    public Session withCommand(SessionCommand command) {
        this.setCommand(command);
        return this;
    }

    public Map<String, String> getDefaultArguments() {
        return this.defaultArguments;
    }

    public void setDefaultArguments(Map<String, String> defaultArguments) {
        this.defaultArguments = defaultArguments;
    }

    public Session withDefaultArguments(Map<String, String> defaultArguments) {
        this.setDefaultArguments(defaultArguments);
        return this;
    }

    public Session addDefaultArgumentsEntry(String key, String value) {
        if (null == this.defaultArguments) {
            this.defaultArguments = new HashMap<String, String>();
        }
        if (this.defaultArguments.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.defaultArguments.put(key, value);
        return this;
    }

    public Session clearDefaultArgumentsEntries() {
        this.defaultArguments = null;
        return this;
    }

    public void setConnections(ConnectionsList connections) {
        this.connections = connections;
    }

    public ConnectionsList getConnections() {
        return this.connections;
    }

    public Session withConnections(ConnectionsList connections) {
        this.setConnections(connections);
        return this;
    }

    public void setProgress(Double progress) {
        this.progress = progress;
    }

    public Double getProgress() {
        return this.progress;
    }

    public Session withProgress(Double progress) {
        this.setProgress(progress);
        return this;
    }

    public void setMaxCapacity(Double maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    public Double getMaxCapacity() {
        return this.maxCapacity;
    }

    public Session withMaxCapacity(Double maxCapacity) {
        this.setMaxCapacity(maxCapacity);
        return this;
    }

    public void setSecurityConfiguration(String securityConfiguration) {
        this.securityConfiguration = securityConfiguration;
    }

    public String getSecurityConfiguration() {
        return this.securityConfiguration;
    }

    public Session withSecurityConfiguration(String securityConfiguration) {
        this.setSecurityConfiguration(securityConfiguration);
        return this;
    }

    public void setGlueVersion(String glueVersion) {
        this.glueVersion = glueVersion;
    }

    public String getGlueVersion() {
        return this.glueVersion;
    }

    public Session withGlueVersion(String glueVersion) {
        this.setGlueVersion(glueVersion);
        return this;
    }

    public void setNumberOfWorkers(Integer numberOfWorkers) {
        this.numberOfWorkers = numberOfWorkers;
    }

    public Integer getNumberOfWorkers() {
        return this.numberOfWorkers;
    }

    public Session withNumberOfWorkers(Integer numberOfWorkers) {
        this.setNumberOfWorkers(numberOfWorkers);
        return this;
    }

    public void setWorkerType(String workerType) {
        this.workerType = workerType;
    }

    public String getWorkerType() {
        return this.workerType;
    }

    public Session withWorkerType(String workerType) {
        this.setWorkerType(workerType);
        return this;
    }

    public Session withWorkerType(WorkerType workerType) {
        this.workerType = workerType.toString();
        return this;
    }

    public void setCompletedOn(Date completedOn) {
        this.completedOn = completedOn;
    }

    public Date getCompletedOn() {
        return this.completedOn;
    }

    public Session withCompletedOn(Date completedOn) {
        this.setCompletedOn(completedOn);
        return this;
    }

    public void setExecutionTime(Double executionTime) {
        this.executionTime = executionTime;
    }

    public Double getExecutionTime() {
        return this.executionTime;
    }

    public Session withExecutionTime(Double executionTime) {
        this.setExecutionTime(executionTime);
        return this;
    }

    public void setDPUSeconds(Double dPUSeconds) {
        this.dPUSeconds = dPUSeconds;
    }

    public Double getDPUSeconds() {
        return this.dPUSeconds;
    }

    public Session withDPUSeconds(Double dPUSeconds) {
        this.setDPUSeconds(dPUSeconds);
        return this;
    }

    public void setIdleTimeout(Integer idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public Integer getIdleTimeout() {
        return this.idleTimeout;
    }

    public Session withIdleTimeout(Integer idleTimeout) {
        this.setIdleTimeout(idleTimeout);
        return this;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public Session withProfileName(String profileName) {
        this.setProfileName(profileName);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getCreatedOn() != null) {
            sb.append("CreatedOn: ").append(this.getCreatedOn()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getErrorMessage() != null) {
            sb.append("ErrorMessage: ").append(this.getErrorMessage()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getRole() != null) {
            sb.append("Role: ").append(this.getRole()).append(",");
        }
        if (this.getCommand() != null) {
            sb.append("Command: ").append(this.getCommand()).append(",");
        }
        if (this.getDefaultArguments() != null) {
            sb.append("DefaultArguments: ").append(this.getDefaultArguments()).append(",");
        }
        if (this.getConnections() != null) {
            sb.append("Connections: ").append(this.getConnections()).append(",");
        }
        if (this.getProgress() != null) {
            sb.append("Progress: ").append(this.getProgress()).append(",");
        }
        if (this.getMaxCapacity() != null) {
            sb.append("MaxCapacity: ").append(this.getMaxCapacity()).append(",");
        }
        if (this.getSecurityConfiguration() != null) {
            sb.append("SecurityConfiguration: ").append(this.getSecurityConfiguration()).append(",");
        }
        if (this.getGlueVersion() != null) {
            sb.append("GlueVersion: ").append(this.getGlueVersion()).append(",");
        }
        if (this.getNumberOfWorkers() != null) {
            sb.append("NumberOfWorkers: ").append(this.getNumberOfWorkers()).append(",");
        }
        if (this.getWorkerType() != null) {
            sb.append("WorkerType: ").append(this.getWorkerType()).append(",");
        }
        if (this.getCompletedOn() != null) {
            sb.append("CompletedOn: ").append(this.getCompletedOn()).append(",");
        }
        if (this.getExecutionTime() != null) {
            sb.append("ExecutionTime: ").append(this.getExecutionTime()).append(",");
        }
        if (this.getDPUSeconds() != null) {
            sb.append("DPUSeconds: ").append(this.getDPUSeconds()).append(",");
        }
        if (this.getIdleTimeout() != null) {
            sb.append("IdleTimeout: ").append(this.getIdleTimeout()).append(",");
        }
        if (this.getProfileName() != null) {
            sb.append("ProfileName: ").append(this.getProfileName());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Session)) {
            return false;
        }
        Session other = (Session)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getCreatedOn() == null ^ this.getCreatedOn() == null) {
            return false;
        }
        if (other.getCreatedOn() != null && !other.getCreatedOn().equals(this.getCreatedOn())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getErrorMessage() == null ^ this.getErrorMessage() == null) {
            return false;
        }
        if (other.getErrorMessage() != null && !other.getErrorMessage().equals(this.getErrorMessage())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getRole() == null ^ this.getRole() == null) {
            return false;
        }
        if (other.getRole() != null && !other.getRole().equals(this.getRole())) {
            return false;
        }
        if (other.getCommand() == null ^ this.getCommand() == null) {
            return false;
        }
        if (other.getCommand() != null && !other.getCommand().equals(this.getCommand())) {
            return false;
        }
        if (other.getDefaultArguments() == null ^ this.getDefaultArguments() == null) {
            return false;
        }
        if (other.getDefaultArguments() != null && !other.getDefaultArguments().equals(this.getDefaultArguments())) {
            return false;
        }
        if (other.getConnections() == null ^ this.getConnections() == null) {
            return false;
        }
        if (other.getConnections() != null && !other.getConnections().equals(this.getConnections())) {
            return false;
        }
        if (other.getProgress() == null ^ this.getProgress() == null) {
            return false;
        }
        if (other.getProgress() != null && !other.getProgress().equals(this.getProgress())) {
            return false;
        }
        if (other.getMaxCapacity() == null ^ this.getMaxCapacity() == null) {
            return false;
        }
        if (other.getMaxCapacity() != null && !other.getMaxCapacity().equals(this.getMaxCapacity())) {
            return false;
        }
        if (other.getSecurityConfiguration() == null ^ this.getSecurityConfiguration() == null) {
            return false;
        }
        if (other.getSecurityConfiguration() != null && !other.getSecurityConfiguration().equals(this.getSecurityConfiguration())) {
            return false;
        }
        if (other.getGlueVersion() == null ^ this.getGlueVersion() == null) {
            return false;
        }
        if (other.getGlueVersion() != null && !other.getGlueVersion().equals(this.getGlueVersion())) {
            return false;
        }
        if (other.getNumberOfWorkers() == null ^ this.getNumberOfWorkers() == null) {
            return false;
        }
        if (other.getNumberOfWorkers() != null && !other.getNumberOfWorkers().equals(this.getNumberOfWorkers())) {
            return false;
        }
        if (other.getWorkerType() == null ^ this.getWorkerType() == null) {
            return false;
        }
        if (other.getWorkerType() != null && !other.getWorkerType().equals(this.getWorkerType())) {
            return false;
        }
        if (other.getCompletedOn() == null ^ this.getCompletedOn() == null) {
            return false;
        }
        if (other.getCompletedOn() != null && !other.getCompletedOn().equals(this.getCompletedOn())) {
            return false;
        }
        if (other.getExecutionTime() == null ^ this.getExecutionTime() == null) {
            return false;
        }
        if (other.getExecutionTime() != null && !other.getExecutionTime().equals(this.getExecutionTime())) {
            return false;
        }
        if (other.getDPUSeconds() == null ^ this.getDPUSeconds() == null) {
            return false;
        }
        if (other.getDPUSeconds() != null && !other.getDPUSeconds().equals(this.getDPUSeconds())) {
            return false;
        }
        if (other.getIdleTimeout() == null ^ this.getIdleTimeout() == null) {
            return false;
        }
        if (other.getIdleTimeout() != null && !other.getIdleTimeout().equals(this.getIdleTimeout())) {
            return false;
        }
        if (other.getProfileName() == null ^ this.getProfileName() == null) {
            return false;
        }
        return other.getProfileName() == null || other.getProfileName().equals(this.getProfileName());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedOn() == null ? 0 : this.getCreatedOn().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getErrorMessage() == null ? 0 : this.getErrorMessage().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getRole() == null ? 0 : this.getRole().hashCode());
        hashCode = 31 * hashCode + (this.getCommand() == null ? 0 : this.getCommand().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultArguments() == null ? 0 : this.getDefaultArguments().hashCode());
        hashCode = 31 * hashCode + (this.getConnections() == null ? 0 : this.getConnections().hashCode());
        hashCode = 31 * hashCode + (this.getProgress() == null ? 0 : this.getProgress().hashCode());
        hashCode = 31 * hashCode + (this.getMaxCapacity() == null ? 0 : this.getMaxCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityConfiguration() == null ? 0 : this.getSecurityConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getGlueVersion() == null ? 0 : this.getGlueVersion().hashCode());
        hashCode = 31 * hashCode + (this.getNumberOfWorkers() == null ? 0 : this.getNumberOfWorkers().hashCode());
        hashCode = 31 * hashCode + (this.getWorkerType() == null ? 0 : this.getWorkerType().hashCode());
        hashCode = 31 * hashCode + (this.getCompletedOn() == null ? 0 : this.getCompletedOn().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionTime() == null ? 0 : this.getExecutionTime().hashCode());
        hashCode = 31 * hashCode + (this.getDPUSeconds() == null ? 0 : this.getDPUSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getIdleTimeout() == null ? 0 : this.getIdleTimeout().hashCode());
        hashCode = 31 * hashCode + (this.getProfileName() == null ? 0 : this.getProfileName().hashCode());
        return hashCode;
    }

    public Session clone() {
        try {
            return (Session)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SessionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

