/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.glue.model.ColumnRowFilter;
import com.amazonaws.services.glue.model.Permission;
import com.amazonaws.services.glue.model.Table;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GetUnfilteredTableMetadataResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private Table table;
    private List<String> authorizedColumns;
    private Boolean isRegisteredWithLakeFormation;
    private List<ColumnRowFilter> cellFilters;
    private String queryAuthorizationId;
    private String resourceArn;
    private List<String> permissions;

    public void setTable(Table table) {
        this.table = table;
    }

    public Table getTable() {
        return this.table;
    }

    public GetUnfilteredTableMetadataResult withTable(Table table) {
        this.setTable(table);
        return this;
    }

    public List<String> getAuthorizedColumns() {
        return this.authorizedColumns;
    }

    public void setAuthorizedColumns(Collection<String> authorizedColumns) {
        if (authorizedColumns == null) {
            this.authorizedColumns = null;
            return;
        }
        this.authorizedColumns = new ArrayList<String>(authorizedColumns);
    }

    public GetUnfilteredTableMetadataResult withAuthorizedColumns(String ... authorizedColumns) {
        if (this.authorizedColumns == null) {
            this.setAuthorizedColumns(new ArrayList<String>(authorizedColumns.length));
        }
        for (String ele : authorizedColumns) {
            this.authorizedColumns.add(ele);
        }
        return this;
    }

    public GetUnfilteredTableMetadataResult withAuthorizedColumns(Collection<String> authorizedColumns) {
        this.setAuthorizedColumns(authorizedColumns);
        return this;
    }

    public void setIsRegisteredWithLakeFormation(Boolean isRegisteredWithLakeFormation) {
        this.isRegisteredWithLakeFormation = isRegisteredWithLakeFormation;
    }

    public Boolean getIsRegisteredWithLakeFormation() {
        return this.isRegisteredWithLakeFormation;
    }

    public GetUnfilteredTableMetadataResult withIsRegisteredWithLakeFormation(Boolean isRegisteredWithLakeFormation) {
        this.setIsRegisteredWithLakeFormation(isRegisteredWithLakeFormation);
        return this;
    }

    public Boolean isRegisteredWithLakeFormation() {
        return this.isRegisteredWithLakeFormation;
    }

    public List<ColumnRowFilter> getCellFilters() {
        return this.cellFilters;
    }

    public void setCellFilters(Collection<ColumnRowFilter> cellFilters) {
        if (cellFilters == null) {
            this.cellFilters = null;
            return;
        }
        this.cellFilters = new ArrayList<ColumnRowFilter>(cellFilters);
    }

    public GetUnfilteredTableMetadataResult withCellFilters(ColumnRowFilter ... cellFilters) {
        if (this.cellFilters == null) {
            this.setCellFilters(new ArrayList<ColumnRowFilter>(cellFilters.length));
        }
        for (ColumnRowFilter ele : cellFilters) {
            this.cellFilters.add(ele);
        }
        return this;
    }

    public GetUnfilteredTableMetadataResult withCellFilters(Collection<ColumnRowFilter> cellFilters) {
        this.setCellFilters(cellFilters);
        return this;
    }

    public void setQueryAuthorizationId(String queryAuthorizationId) {
        this.queryAuthorizationId = queryAuthorizationId;
    }

    public String getQueryAuthorizationId() {
        return this.queryAuthorizationId;
    }

    public GetUnfilteredTableMetadataResult withQueryAuthorizationId(String queryAuthorizationId) {
        this.setQueryAuthorizationId(queryAuthorizationId);
        return this;
    }

    public void setResourceArn(String resourceArn) {
        this.resourceArn = resourceArn;
    }

    public String getResourceArn() {
        return this.resourceArn;
    }

    public GetUnfilteredTableMetadataResult withResourceArn(String resourceArn) {
        this.setResourceArn(resourceArn);
        return this;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Collection<String> permissions) {
        if (permissions == null) {
            this.permissions = null;
            return;
        }
        this.permissions = new ArrayList<String>(permissions);
    }

    public GetUnfilteredTableMetadataResult withPermissions(String ... permissions) {
        if (this.permissions == null) {
            this.setPermissions(new ArrayList<String>(permissions.length));
        }
        for (String ele : permissions) {
            this.permissions.add(ele);
        }
        return this;
    }

    public GetUnfilteredTableMetadataResult withPermissions(Collection<String> permissions) {
        this.setPermissions(permissions);
        return this;
    }

    public GetUnfilteredTableMetadataResult withPermissions(Permission ... permissions) {
        ArrayList<String> permissionsCopy = new ArrayList<String>(permissions.length);
        for (Permission value : permissions) {
            permissionsCopy.add(value.toString());
        }
        if (this.getPermissions() == null) {
            this.setPermissions(permissionsCopy);
        } else {
            this.getPermissions().addAll(permissionsCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTable() != null) {
            sb.append("Table: ").append(this.getTable()).append(",");
        }
        if (this.getAuthorizedColumns() != null) {
            sb.append("AuthorizedColumns: ").append(this.getAuthorizedColumns()).append(",");
        }
        if (this.getIsRegisteredWithLakeFormation() != null) {
            sb.append("IsRegisteredWithLakeFormation: ").append(this.getIsRegisteredWithLakeFormation()).append(",");
        }
        if (this.getCellFilters() != null) {
            sb.append("CellFilters: ").append(this.getCellFilters()).append(",");
        }
        if (this.getQueryAuthorizationId() != null) {
            sb.append("QueryAuthorizationId: ").append(this.getQueryAuthorizationId()).append(",");
        }
        if (this.getResourceArn() != null) {
            sb.append("ResourceArn: ").append(this.getResourceArn()).append(",");
        }
        if (this.getPermissions() != null) {
            sb.append("Permissions: ").append(this.getPermissions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUnfilteredTableMetadataResult)) {
            return false;
        }
        GetUnfilteredTableMetadataResult other = (GetUnfilteredTableMetadataResult)obj;
        if (other.getTable() == null ^ this.getTable() == null) {
            return false;
        }
        if (other.getTable() != null && !other.getTable().equals(this.getTable())) {
            return false;
        }
        if (other.getAuthorizedColumns() == null ^ this.getAuthorizedColumns() == null) {
            return false;
        }
        if (other.getAuthorizedColumns() != null && !other.getAuthorizedColumns().equals(this.getAuthorizedColumns())) {
            return false;
        }
        if (other.getIsRegisteredWithLakeFormation() == null ^ this.getIsRegisteredWithLakeFormation() == null) {
            return false;
        }
        if (other.getIsRegisteredWithLakeFormation() != null && !other.getIsRegisteredWithLakeFormation().equals(this.getIsRegisteredWithLakeFormation())) {
            return false;
        }
        if (other.getCellFilters() == null ^ this.getCellFilters() == null) {
            return false;
        }
        if (other.getCellFilters() != null && !other.getCellFilters().equals(this.getCellFilters())) {
            return false;
        }
        if (other.getQueryAuthorizationId() == null ^ this.getQueryAuthorizationId() == null) {
            return false;
        }
        if (other.getQueryAuthorizationId() != null && !other.getQueryAuthorizationId().equals(this.getQueryAuthorizationId())) {
            return false;
        }
        if (other.getResourceArn() == null ^ this.getResourceArn() == null) {
            return false;
        }
        if (other.getResourceArn() != null && !other.getResourceArn().equals(this.getResourceArn())) {
            return false;
        }
        if (other.getPermissions() == null ^ this.getPermissions() == null) {
            return false;
        }
        return other.getPermissions() == null || other.getPermissions().equals(this.getPermissions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTable() == null ? 0 : this.getTable().hashCode());
        hashCode = 31 * hashCode + (this.getAuthorizedColumns() == null ? 0 : this.getAuthorizedColumns().hashCode());
        hashCode = 31 * hashCode + (this.getIsRegisteredWithLakeFormation() == null ? 0 : this.getIsRegisteredWithLakeFormation().hashCode());
        hashCode = 31 * hashCode + (this.getCellFilters() == null ? 0 : this.getCellFilters().hashCode());
        hashCode = 31 * hashCode + (this.getQueryAuthorizationId() == null ? 0 : this.getQueryAuthorizationId().hashCode());
        hashCode = 31 * hashCode + (this.getResourceArn() == null ? 0 : this.getResourceArn().hashCode());
        hashCode = 31 * hashCode + (this.getPermissions() == null ? 0 : this.getPermissions().hashCode());
        return hashCode;
    }

    public GetUnfilteredTableMetadataResult clone() {
        try {
            return (GetUnfilteredTableMetadataResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

