/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.WorkflowRun;
import java.util.Date;
import java.util.Map;

@SdkInternalApi
public class WorkflowRunMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> WORKFLOWRUNID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WorkflowRunId").build();
    private static final MarshallingInfo<String> PREVIOUSRUNID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PreviousRunId").build();
    private static final MarshallingInfo<Map> WORKFLOWRUNPROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("WorkflowRunProperties").build();
    private static final MarshallingInfo<Date> STARTEDON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartedOn").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> COMPLETEDON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompletedOn").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> ERRORMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorMessage").build();
    private static final MarshallingInfo<StructuredPojo> STATISTICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Statistics").build();
    private static final MarshallingInfo<StructuredPojo> GRAPH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Graph").build();
    private static final MarshallingInfo<StructuredPojo> STARTINGEVENTBATCHCONDITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartingEventBatchCondition").build();
    private static final WorkflowRunMarshaller instance = new WorkflowRunMarshaller();

    public static WorkflowRunMarshaller getInstance() {
        return instance;
    }

    public void marshall(WorkflowRun workflowRun, ProtocolMarshaller protocolMarshaller) {
        if (workflowRun == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)workflowRun.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)workflowRun.getWorkflowRunId(), WORKFLOWRUNID_BINDING);
            protocolMarshaller.marshall((Object)workflowRun.getPreviousRunId(), PREVIOUSRUNID_BINDING);
            protocolMarshaller.marshall(workflowRun.getWorkflowRunProperties(), WORKFLOWRUNPROPERTIES_BINDING);
            protocolMarshaller.marshall((Object)workflowRun.getStartedOn(), STARTEDON_BINDING);
            protocolMarshaller.marshall((Object)workflowRun.getCompletedOn(), COMPLETEDON_BINDING);
            protocolMarshaller.marshall((Object)workflowRun.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)workflowRun.getErrorMessage(), ERRORMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)workflowRun.getStatistics(), STATISTICS_BINDING);
            protocolMarshaller.marshall((Object)workflowRun.getGraph(), GRAPH_BINDING);
            protocolMarshaller.marshall((Object)workflowRun.getStartingEventBatchCondition(), STARTINGEVENTBATCHCONDITION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

