/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.glue.model.OpenTableFormatInput;
import com.amazonaws.services.glue.model.PartitionIndex;
import com.amazonaws.services.glue.model.TableInput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateTableRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String catalogId;
    private String databaseName;
    private TableInput tableInput;
    private List<PartitionIndex> partitionIndexes;
    private String transactionId;
    private OpenTableFormatInput openTableFormatInput;

    public void setCatalogId(String catalogId) {
        this.catalogId = catalogId;
    }

    public String getCatalogId() {
        return this.catalogId;
    }

    public CreateTableRequest withCatalogId(String catalogId) {
        this.setCatalogId(catalogId);
        return this;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public CreateTableRequest withDatabaseName(String databaseName) {
        this.setDatabaseName(databaseName);
        return this;
    }

    public void setTableInput(TableInput tableInput) {
        this.tableInput = tableInput;
    }

    public TableInput getTableInput() {
        return this.tableInput;
    }

    public CreateTableRequest withTableInput(TableInput tableInput) {
        this.setTableInput(tableInput);
        return this;
    }

    public List<PartitionIndex> getPartitionIndexes() {
        return this.partitionIndexes;
    }

    public void setPartitionIndexes(Collection<PartitionIndex> partitionIndexes) {
        if (partitionIndexes == null) {
            this.partitionIndexes = null;
            return;
        }
        this.partitionIndexes = new ArrayList<PartitionIndex>(partitionIndexes);
    }

    public CreateTableRequest withPartitionIndexes(PartitionIndex ... partitionIndexes) {
        if (this.partitionIndexes == null) {
            this.setPartitionIndexes(new ArrayList<PartitionIndex>(partitionIndexes.length));
        }
        for (PartitionIndex ele : partitionIndexes) {
            this.partitionIndexes.add(ele);
        }
        return this;
    }

    public CreateTableRequest withPartitionIndexes(Collection<PartitionIndex> partitionIndexes) {
        this.setPartitionIndexes(partitionIndexes);
        return this;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public CreateTableRequest withTransactionId(String transactionId) {
        this.setTransactionId(transactionId);
        return this;
    }

    public void setOpenTableFormatInput(OpenTableFormatInput openTableFormatInput) {
        this.openTableFormatInput = openTableFormatInput;
    }

    public OpenTableFormatInput getOpenTableFormatInput() {
        return this.openTableFormatInput;
    }

    public CreateTableRequest withOpenTableFormatInput(OpenTableFormatInput openTableFormatInput) {
        this.setOpenTableFormatInput(openTableFormatInput);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCatalogId() != null) {
            sb.append("CatalogId: ").append(this.getCatalogId()).append(",");
        }
        if (this.getDatabaseName() != null) {
            sb.append("DatabaseName: ").append(this.getDatabaseName()).append(",");
        }
        if (this.getTableInput() != null) {
            sb.append("TableInput: ").append(this.getTableInput()).append(",");
        }
        if (this.getPartitionIndexes() != null) {
            sb.append("PartitionIndexes: ").append(this.getPartitionIndexes()).append(",");
        }
        if (this.getTransactionId() != null) {
            sb.append("TransactionId: ").append(this.getTransactionId()).append(",");
        }
        if (this.getOpenTableFormatInput() != null) {
            sb.append("OpenTableFormatInput: ").append(this.getOpenTableFormatInput());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTableRequest)) {
            return false;
        }
        CreateTableRequest other = (CreateTableRequest)obj;
        if (other.getCatalogId() == null ^ this.getCatalogId() == null) {
            return false;
        }
        if (other.getCatalogId() != null && !other.getCatalogId().equals(this.getCatalogId())) {
            return false;
        }
        if (other.getDatabaseName() == null ^ this.getDatabaseName() == null) {
            return false;
        }
        if (other.getDatabaseName() != null && !other.getDatabaseName().equals(this.getDatabaseName())) {
            return false;
        }
        if (other.getTableInput() == null ^ this.getTableInput() == null) {
            return false;
        }
        if (other.getTableInput() != null && !other.getTableInput().equals(this.getTableInput())) {
            return false;
        }
        if (other.getPartitionIndexes() == null ^ this.getPartitionIndexes() == null) {
            return false;
        }
        if (other.getPartitionIndexes() != null && !other.getPartitionIndexes().equals(this.getPartitionIndexes())) {
            return false;
        }
        if (other.getTransactionId() == null ^ this.getTransactionId() == null) {
            return false;
        }
        if (other.getTransactionId() != null && !other.getTransactionId().equals(this.getTransactionId())) {
            return false;
        }
        if (other.getOpenTableFormatInput() == null ^ this.getOpenTableFormatInput() == null) {
            return false;
        }
        return other.getOpenTableFormatInput() == null || other.getOpenTableFormatInput().equals(this.getOpenTableFormatInput());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCatalogId() == null ? 0 : this.getCatalogId().hashCode());
        hashCode = 31 * hashCode + (this.getDatabaseName() == null ? 0 : this.getDatabaseName().hashCode());
        hashCode = 31 * hashCode + (this.getTableInput() == null ? 0 : this.getTableInput().hashCode());
        hashCode = 31 * hashCode + (this.getPartitionIndexes() == null ? 0 : this.getPartitionIndexes().hashCode());
        hashCode = 31 * hashCode + (this.getTransactionId() == null ? 0 : this.getTransactionId().hashCode());
        hashCode = 31 * hashCode + (this.getOpenTableFormatInput() == null ? 0 : this.getOpenTableFormatInput().hashCode());
        return hashCode;
    }

    public CreateTableRequest clone() {
        return (CreateTableRequest)super.clone();
    }
}

