/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.globalaccelerator.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.globalaccelerator.model.CustomRoutingAccelerator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListCustomRoutingAcceleratorsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<CustomRoutingAccelerator> accelerators;
    private String nextToken;

    public List<CustomRoutingAccelerator> getAccelerators() {
        return this.accelerators;
    }

    public void setAccelerators(Collection<CustomRoutingAccelerator> accelerators) {
        if (accelerators == null) {
            this.accelerators = null;
            return;
        }
        this.accelerators = new ArrayList<CustomRoutingAccelerator>(accelerators);
    }

    public ListCustomRoutingAcceleratorsResult withAccelerators(CustomRoutingAccelerator ... accelerators) {
        if (this.accelerators == null) {
            this.setAccelerators(new ArrayList<CustomRoutingAccelerator>(accelerators.length));
        }
        for (CustomRoutingAccelerator ele : accelerators) {
            this.accelerators.add(ele);
        }
        return this;
    }

    public ListCustomRoutingAcceleratorsResult withAccelerators(Collection<CustomRoutingAccelerator> accelerators) {
        this.setAccelerators(accelerators);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListCustomRoutingAcceleratorsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccelerators() != null) {
            sb.append("Accelerators: ").append(this.getAccelerators()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomRoutingAcceleratorsResult)) {
            return false;
        }
        ListCustomRoutingAcceleratorsResult other = (ListCustomRoutingAcceleratorsResult)obj;
        if (other.getAccelerators() == null ^ this.getAccelerators() == null) {
            return false;
        }
        if (other.getAccelerators() != null && !other.getAccelerators().equals(this.getAccelerators())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccelerators() == null ? 0 : this.getAccelerators().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListCustomRoutingAcceleratorsResult clone() {
        try {
            return (ListCustomRoutingAcceleratorsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

