/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.globalaccelerator.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.globalaccelerator.model.EndpointConfiguration;
import com.amazonaws.services.globalaccelerator.model.HealthCheckProtocol;
import com.amazonaws.services.globalaccelerator.model.PortOverride;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateEndpointGroupRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String endpointGroupArn;
    private List<EndpointConfiguration> endpointConfigurations;
    private Float trafficDialPercentage;
    private Integer healthCheckPort;
    private String healthCheckProtocol;
    private String healthCheckPath;
    private Integer healthCheckIntervalSeconds;
    private Integer thresholdCount;
    private List<PortOverride> portOverrides;

    public void setEndpointGroupArn(String endpointGroupArn) {
        this.endpointGroupArn = endpointGroupArn;
    }

    public String getEndpointGroupArn() {
        return this.endpointGroupArn;
    }

    public UpdateEndpointGroupRequest withEndpointGroupArn(String endpointGroupArn) {
        this.setEndpointGroupArn(endpointGroupArn);
        return this;
    }

    public List<EndpointConfiguration> getEndpointConfigurations() {
        return this.endpointConfigurations;
    }

    public void setEndpointConfigurations(Collection<EndpointConfiguration> endpointConfigurations) {
        if (endpointConfigurations == null) {
            this.endpointConfigurations = null;
            return;
        }
        this.endpointConfigurations = new ArrayList<EndpointConfiguration>(endpointConfigurations);
    }

    public UpdateEndpointGroupRequest withEndpointConfigurations(EndpointConfiguration ... endpointConfigurations) {
        if (this.endpointConfigurations == null) {
            this.setEndpointConfigurations(new ArrayList<EndpointConfiguration>(endpointConfigurations.length));
        }
        for (EndpointConfiguration ele : endpointConfigurations) {
            this.endpointConfigurations.add(ele);
        }
        return this;
    }

    public UpdateEndpointGroupRequest withEndpointConfigurations(Collection<EndpointConfiguration> endpointConfigurations) {
        this.setEndpointConfigurations(endpointConfigurations);
        return this;
    }

    public void setTrafficDialPercentage(Float trafficDialPercentage) {
        this.trafficDialPercentage = trafficDialPercentage;
    }

    public Float getTrafficDialPercentage() {
        return this.trafficDialPercentage;
    }

    public UpdateEndpointGroupRequest withTrafficDialPercentage(Float trafficDialPercentage) {
        this.setTrafficDialPercentage(trafficDialPercentage);
        return this;
    }

    public void setHealthCheckPort(Integer healthCheckPort) {
        this.healthCheckPort = healthCheckPort;
    }

    public Integer getHealthCheckPort() {
        return this.healthCheckPort;
    }

    public UpdateEndpointGroupRequest withHealthCheckPort(Integer healthCheckPort) {
        this.setHealthCheckPort(healthCheckPort);
        return this;
    }

    public void setHealthCheckProtocol(String healthCheckProtocol) {
        this.healthCheckProtocol = healthCheckProtocol;
    }

    public String getHealthCheckProtocol() {
        return this.healthCheckProtocol;
    }

    public UpdateEndpointGroupRequest withHealthCheckProtocol(String healthCheckProtocol) {
        this.setHealthCheckProtocol(healthCheckProtocol);
        return this;
    }

    public UpdateEndpointGroupRequest withHealthCheckProtocol(HealthCheckProtocol healthCheckProtocol) {
        this.healthCheckProtocol = healthCheckProtocol.toString();
        return this;
    }

    public void setHealthCheckPath(String healthCheckPath) {
        this.healthCheckPath = healthCheckPath;
    }

    public String getHealthCheckPath() {
        return this.healthCheckPath;
    }

    public UpdateEndpointGroupRequest withHealthCheckPath(String healthCheckPath) {
        this.setHealthCheckPath(healthCheckPath);
        return this;
    }

    public void setHealthCheckIntervalSeconds(Integer healthCheckIntervalSeconds) {
        this.healthCheckIntervalSeconds = healthCheckIntervalSeconds;
    }

    public Integer getHealthCheckIntervalSeconds() {
        return this.healthCheckIntervalSeconds;
    }

    public UpdateEndpointGroupRequest withHealthCheckIntervalSeconds(Integer healthCheckIntervalSeconds) {
        this.setHealthCheckIntervalSeconds(healthCheckIntervalSeconds);
        return this;
    }

    public void setThresholdCount(Integer thresholdCount) {
        this.thresholdCount = thresholdCount;
    }

    public Integer getThresholdCount() {
        return this.thresholdCount;
    }

    public UpdateEndpointGroupRequest withThresholdCount(Integer thresholdCount) {
        this.setThresholdCount(thresholdCount);
        return this;
    }

    public List<PortOverride> getPortOverrides() {
        return this.portOverrides;
    }

    public void setPortOverrides(Collection<PortOverride> portOverrides) {
        if (portOverrides == null) {
            this.portOverrides = null;
            return;
        }
        this.portOverrides = new ArrayList<PortOverride>(portOverrides);
    }

    public UpdateEndpointGroupRequest withPortOverrides(PortOverride ... portOverrides) {
        if (this.portOverrides == null) {
            this.setPortOverrides(new ArrayList<PortOverride>(portOverrides.length));
        }
        for (PortOverride ele : portOverrides) {
            this.portOverrides.add(ele);
        }
        return this;
    }

    public UpdateEndpointGroupRequest withPortOverrides(Collection<PortOverride> portOverrides) {
        this.setPortOverrides(portOverrides);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEndpointGroupArn() != null) {
            sb.append("EndpointGroupArn: ").append(this.getEndpointGroupArn()).append(",");
        }
        if (this.getEndpointConfigurations() != null) {
            sb.append("EndpointConfigurations: ").append(this.getEndpointConfigurations()).append(",");
        }
        if (this.getTrafficDialPercentage() != null) {
            sb.append("TrafficDialPercentage: ").append(this.getTrafficDialPercentage()).append(",");
        }
        if (this.getHealthCheckPort() != null) {
            sb.append("HealthCheckPort: ").append(this.getHealthCheckPort()).append(",");
        }
        if (this.getHealthCheckProtocol() != null) {
            sb.append("HealthCheckProtocol: ").append(this.getHealthCheckProtocol()).append(",");
        }
        if (this.getHealthCheckPath() != null) {
            sb.append("HealthCheckPath: ").append(this.getHealthCheckPath()).append(",");
        }
        if (this.getHealthCheckIntervalSeconds() != null) {
            sb.append("HealthCheckIntervalSeconds: ").append(this.getHealthCheckIntervalSeconds()).append(",");
        }
        if (this.getThresholdCount() != null) {
            sb.append("ThresholdCount: ").append(this.getThresholdCount()).append(",");
        }
        if (this.getPortOverrides() != null) {
            sb.append("PortOverrides: ").append(this.getPortOverrides());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateEndpointGroupRequest)) {
            return false;
        }
        UpdateEndpointGroupRequest other = (UpdateEndpointGroupRequest)obj;
        if (other.getEndpointGroupArn() == null ^ this.getEndpointGroupArn() == null) {
            return false;
        }
        if (other.getEndpointGroupArn() != null && !other.getEndpointGroupArn().equals(this.getEndpointGroupArn())) {
            return false;
        }
        if (other.getEndpointConfigurations() == null ^ this.getEndpointConfigurations() == null) {
            return false;
        }
        if (other.getEndpointConfigurations() != null && !other.getEndpointConfigurations().equals(this.getEndpointConfigurations())) {
            return false;
        }
        if (other.getTrafficDialPercentage() == null ^ this.getTrafficDialPercentage() == null) {
            return false;
        }
        if (other.getTrafficDialPercentage() != null && !other.getTrafficDialPercentage().equals(this.getTrafficDialPercentage())) {
            return false;
        }
        if (other.getHealthCheckPort() == null ^ this.getHealthCheckPort() == null) {
            return false;
        }
        if (other.getHealthCheckPort() != null && !other.getHealthCheckPort().equals(this.getHealthCheckPort())) {
            return false;
        }
        if (other.getHealthCheckProtocol() == null ^ this.getHealthCheckProtocol() == null) {
            return false;
        }
        if (other.getHealthCheckProtocol() != null && !other.getHealthCheckProtocol().equals(this.getHealthCheckProtocol())) {
            return false;
        }
        if (other.getHealthCheckPath() == null ^ this.getHealthCheckPath() == null) {
            return false;
        }
        if (other.getHealthCheckPath() != null && !other.getHealthCheckPath().equals(this.getHealthCheckPath())) {
            return false;
        }
        if (other.getHealthCheckIntervalSeconds() == null ^ this.getHealthCheckIntervalSeconds() == null) {
            return false;
        }
        if (other.getHealthCheckIntervalSeconds() != null && !other.getHealthCheckIntervalSeconds().equals(this.getHealthCheckIntervalSeconds())) {
            return false;
        }
        if (other.getThresholdCount() == null ^ this.getThresholdCount() == null) {
            return false;
        }
        if (other.getThresholdCount() != null && !other.getThresholdCount().equals(this.getThresholdCount())) {
            return false;
        }
        if (other.getPortOverrides() == null ^ this.getPortOverrides() == null) {
            return false;
        }
        return other.getPortOverrides() == null || other.getPortOverrides().equals(this.getPortOverrides());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEndpointGroupArn() == null ? 0 : this.getEndpointGroupArn().hashCode());
        hashCode = 31 * hashCode + (this.getEndpointConfigurations() == null ? 0 : this.getEndpointConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getTrafficDialPercentage() == null ? 0 : this.getTrafficDialPercentage().hashCode());
        hashCode = 31 * hashCode + (this.getHealthCheckPort() == null ? 0 : this.getHealthCheckPort().hashCode());
        hashCode = 31 * hashCode + (this.getHealthCheckProtocol() == null ? 0 : this.getHealthCheckProtocol().hashCode());
        hashCode = 31 * hashCode + (this.getHealthCheckPath() == null ? 0 : this.getHealthCheckPath().hashCode());
        hashCode = 31 * hashCode + (this.getHealthCheckIntervalSeconds() == null ? 0 : this.getHealthCheckIntervalSeconds().hashCode());
        hashCode = 31 * hashCode + (this.getThresholdCount() == null ? 0 : this.getThresholdCount().hashCode());
        hashCode = 31 * hashCode + (this.getPortOverrides() == null ? 0 : this.getPortOverrides().hashCode());
        return hashCode;
    }

    public UpdateEndpointGroupRequest clone() {
        return (UpdateEndpointGroupRequest)super.clone();
    }
}

