/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.http.JsonErrorResponseHandler;
import com.amazonaws.http.JsonResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.glacier.AmazonGlacier;
import com.amazonaws.services.glacier.model.AbortMultipartUploadRequest;
import com.amazonaws.services.glacier.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.glacier.model.CompleteMultipartUploadResult;
import com.amazonaws.services.glacier.model.CreateVaultRequest;
import com.amazonaws.services.glacier.model.CreateVaultResult;
import com.amazonaws.services.glacier.model.DeleteArchiveRequest;
import com.amazonaws.services.glacier.model.DeleteVaultNotificationsRequest;
import com.amazonaws.services.glacier.model.DeleteVaultRequest;
import com.amazonaws.services.glacier.model.DescribeJobRequest;
import com.amazonaws.services.glacier.model.DescribeJobResult;
import com.amazonaws.services.glacier.model.DescribeVaultRequest;
import com.amazonaws.services.glacier.model.DescribeVaultResult;
import com.amazonaws.services.glacier.model.GetDataRetrievalPolicyRequest;
import com.amazonaws.services.glacier.model.GetDataRetrievalPolicyResult;
import com.amazonaws.services.glacier.model.GetJobOutputRequest;
import com.amazonaws.services.glacier.model.GetJobOutputResult;
import com.amazonaws.services.glacier.model.GetVaultNotificationsRequest;
import com.amazonaws.services.glacier.model.GetVaultNotificationsResult;
import com.amazonaws.services.glacier.model.InitiateJobRequest;
import com.amazonaws.services.glacier.model.InitiateJobResult;
import com.amazonaws.services.glacier.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.glacier.model.InitiateMultipartUploadResult;
import com.amazonaws.services.glacier.model.ListJobsRequest;
import com.amazonaws.services.glacier.model.ListJobsResult;
import com.amazonaws.services.glacier.model.ListMultipartUploadsRequest;
import com.amazonaws.services.glacier.model.ListMultipartUploadsResult;
import com.amazonaws.services.glacier.model.ListPartsRequest;
import com.amazonaws.services.glacier.model.ListPartsResult;
import com.amazonaws.services.glacier.model.ListVaultsRequest;
import com.amazonaws.services.glacier.model.ListVaultsResult;
import com.amazonaws.services.glacier.model.SetDataRetrievalPolicyRequest;
import com.amazonaws.services.glacier.model.SetVaultNotificationsRequest;
import com.amazonaws.services.glacier.model.UploadArchiveRequest;
import com.amazonaws.services.glacier.model.UploadArchiveResult;
import com.amazonaws.services.glacier.model.UploadMultipartPartRequest;
import com.amazonaws.services.glacier.model.UploadMultipartPartResult;
import com.amazonaws.services.glacier.model.transform.AbortMultipartUploadRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.CompleteMultipartUploadRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.CompleteMultipartUploadResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.CreateVaultRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.CreateVaultResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.DeleteArchiveRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.DeleteVaultNotificationsRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.DeleteVaultRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.DescribeJobRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.DescribeJobResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.DescribeVaultRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.DescribeVaultResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.GetDataRetrievalPolicyRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.GetDataRetrievalPolicyResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.GetJobOutputRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.GetJobOutputResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.GetVaultNotificationsRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.GetVaultNotificationsResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.InitiateJobRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.InitiateJobResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.InitiateMultipartUploadRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.InitiateMultipartUploadResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.InvalidParameterValueExceptionUnmarshaller;
import com.amazonaws.services.glacier.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.glacier.model.transform.ListJobsRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.ListJobsResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.ListMultipartUploadsRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.ListMultipartUploadsResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.ListPartsRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.ListPartsResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.ListVaultsRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.ListVaultsResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.MissingParameterValueExceptionUnmarshaller;
import com.amazonaws.services.glacier.model.transform.PolicyEnforcedExceptionUnmarshaller;
import com.amazonaws.services.glacier.model.transform.RequestTimeoutExceptionUnmarshaller;
import com.amazonaws.services.glacier.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.glacier.model.transform.ServiceUnavailableExceptionUnmarshaller;
import com.amazonaws.services.glacier.model.transform.SetDataRetrievalPolicyRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.SetVaultNotificationsRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.UploadArchiveRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.UploadArchiveResultJsonUnmarshaller;
import com.amazonaws.services.glacier.model.transform.UploadMultipartPartRequestMarshaller;
import com.amazonaws.services.glacier.model.transform.UploadMultipartPartResultJsonUnmarshaller;
import com.amazonaws.transform.GlacierErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.ServiceClientHolderInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AmazonGlacierClient
extends AmazonWebServiceClient
implements AmazonGlacier {
    private AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonGlacier.class);
    protected List<GlacierErrorUnmarshaller> jsonErrorUnmarshallers;

    public AmazonGlacierClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), new ClientConfiguration());
    }

    public AmazonGlacierClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonGlacierClient(AWSCredentials awsCredentials) {
        this(awsCredentials, new ClientConfiguration());
    }

    public AmazonGlacierClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(AmazonGlacierClient.adjustClientConfiguration(clientConfiguration));
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonGlacierClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, new ClientConfiguration());
    }

    public AmazonGlacierClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonGlacierClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(AmazonGlacierClient.adjustClientConfiguration(clientConfiguration), requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    private void init() {
        this.jsonErrorUnmarshallers = new ArrayList<GlacierErrorUnmarshaller>();
        this.jsonErrorUnmarshallers.add(new InvalidParameterValueExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new LimitExceededExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new MissingParameterValueExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new PolicyEnforcedExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new RequestTimeoutExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new ServiceUnavailableExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new ResourceNotFoundExceptionUnmarshaller());
        this.jsonErrorUnmarshallers.add(new GlacierErrorUnmarshaller());
        this.setEndpoint("glacier.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/glacier/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/glacier/request.handler2s"));
    }

    private static ClientConfiguration adjustClientConfiguration(ClientConfiguration orig) {
        ClientConfiguration config = orig;
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListVaultsResult listVaults(ListVaultsRequest listVaultsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listVaultsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListVaultsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListVaultsRequestMarshaller().marshall((ListVaultsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listVaultsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListVaultsResultJsonUnmarshaller unmarshaller = new ListVaultsResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListVaultsResult listVaultsResult = (ListVaultsResult)response.getAwsResponse();
            return listVaultsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeJobResult describeJob(DescribeJobRequest describeJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeJobRequestMarshaller().marshall((DescribeJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeJobResultJsonUnmarshaller unmarshaller = new DescribeJobResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeJobResult describeJobResult = (DescribeJobResult)response.getAwsResponse();
            return describeJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPartsResult listParts(ListPartsRequest listPartsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPartsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPartsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPartsRequestMarshaller().marshall((ListPartsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listPartsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListPartsResultJsonUnmarshaller unmarshaller = new ListPartsResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListPartsResult listPartsResult = (ListPartsResult)response.getAwsResponse();
            return listPartsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetVaultNotificationsResult getVaultNotifications(GetVaultNotificationsRequest getVaultNotificationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getVaultNotificationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetVaultNotificationsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetVaultNotificationsRequestMarshaller().marshall((GetVaultNotificationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)getVaultNotificationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            GetVaultNotificationsResultJsonUnmarshaller unmarshaller = new GetVaultNotificationsResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetVaultNotificationsResult getVaultNotificationsResult = (GetVaultNotificationsResult)response.getAwsResponse();
            return getVaultNotificationsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListJobsResult listJobs(ListJobsRequest listJobsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listJobsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListJobsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListJobsRequestMarshaller().marshall((ListJobsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listJobsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListJobsResultJsonUnmarshaller unmarshaller = new ListJobsResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListJobsResult listJobsResult = (ListJobsResult)response.getAwsResponse();
            return listJobsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateVaultResult createVault(CreateVaultRequest createVaultRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createVaultRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateVaultRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateVaultRequestMarshaller().marshall((CreateVaultRequest)super.beforeMarshalling((AmazonWebServiceRequest)createVaultRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CreateVaultResultJsonUnmarshaller unmarshaller = new CreateVaultResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CreateVaultResult createVaultResult = (CreateVaultResult)response.getAwsResponse();
            return createVaultResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest initiateMultipartUploadRequest) {
        ExecutionContext executionContext = this.createExecutionContext(initiateMultipartUploadRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<InitiateMultipartUploadRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new InitiateMultipartUploadRequestMarshaller().marshall((InitiateMultipartUploadRequest)super.beforeMarshalling((AmazonWebServiceRequest)initiateMultipartUploadRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            InitiateMultipartUploadResultJsonUnmarshaller unmarshaller = new InitiateMultipartUploadResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            InitiateMultipartUploadResult initiateMultipartUploadResult = (InitiateMultipartUploadResult)response.getAwsResponse();
            return initiateMultipartUploadResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortMultipartUpload(AbortMultipartUploadRequest abortMultipartUploadRequest) {
        ExecutionContext executionContext = this.createExecutionContext(abortMultipartUploadRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<AbortMultipartUploadRequest> request = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new AbortMultipartUploadRequestMarshaller().marshall((AbortMultipartUploadRequest)super.beforeMarshalling((AmazonWebServiceRequest)abortMultipartUploadRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteArchive(DeleteArchiveRequest deleteArchiveRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteArchiveRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteArchiveRequest> request = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteArchiveRequestMarshaller().marshall((DeleteArchiveRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteArchiveRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetJobOutputResult getJobOutput(GetJobOutputRequest getJobOutputRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getJobOutputRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetJobOutputRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetJobOutputRequestMarshaller().marshall((GetJobOutputRequest)super.beforeMarshalling((AmazonWebServiceRequest)getJobOutputRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            GetJobOutputResultJsonUnmarshaller unmarshaller = new GetJobOutputResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            responseHandler.needsConnectionLeftOpen = true;
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetJobOutputResult awsResponse = (GetJobOutputResult)response.getAwsResponse();
            awsResponse.setBody((InputStream)new ServiceClientHolderInputStream(awsResponse.getBody(), (AmazonWebServiceClient)this));
            GetJobOutputResult getJobOutputResult = (GetJobOutputResult)response.getAwsResponse();
            return getJobOutputResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InitiateJobResult initiateJob(InitiateJobRequest initiateJobRequest) {
        ExecutionContext executionContext = this.createExecutionContext(initiateJobRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<InitiateJobRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new InitiateJobRequestMarshaller().marshall((InitiateJobRequest)super.beforeMarshalling((AmazonWebServiceRequest)initiateJobRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            InitiateJobResultJsonUnmarshaller unmarshaller = new InitiateJobResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            InitiateJobResult initiateJobResult = (InitiateJobResult)response.getAwsResponse();
            return initiateJobResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UploadArchiveResult uploadArchive(UploadArchiveRequest uploadArchiveRequest) {
        ExecutionContext executionContext = this.createExecutionContext(uploadArchiveRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UploadArchiveRequest> request = null;
        Response response = null;
        InputStream isOrig = uploadArchiveRequest.getBody();
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UploadArchiveRequestMarshaller().marshall((UploadArchiveRequest)super.beforeMarshalling((AmazonWebServiceRequest)uploadArchiveRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            UploadArchiveResultJsonUnmarshaller unmarshaller = new UploadArchiveResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            UploadArchiveResult uploadArchiveResult = (UploadArchiveResult)response.getAwsResponse();
            return uploadArchiveResult;
        }
        finally {
            uploadArchiveRequest.setBody(isOrig);
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVaultNotifications(SetVaultNotificationsRequest setVaultNotificationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setVaultNotificationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SetVaultNotificationsRequest> request = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SetVaultNotificationsRequestMarshaller().marshall((SetVaultNotificationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)setVaultNotificationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest) {
        ExecutionContext executionContext = this.createExecutionContext(completeMultipartUploadRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CompleteMultipartUploadRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CompleteMultipartUploadRequestMarshaller().marshall((CompleteMultipartUploadRequest)super.beforeMarshalling((AmazonWebServiceRequest)completeMultipartUploadRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            CompleteMultipartUploadResultJsonUnmarshaller unmarshaller = new CompleteMultipartUploadResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            CompleteMultipartUploadResult completeMultipartUploadResult = (CompleteMultipartUploadResult)response.getAwsResponse();
            return completeMultipartUploadResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UploadMultipartPartResult uploadMultipartPart(UploadMultipartPartRequest uploadMultipartPartRequest) {
        ExecutionContext executionContext = this.createExecutionContext(uploadMultipartPartRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UploadMultipartPartRequest> request = null;
        Response response = null;
        InputStream isOrig = uploadMultipartPartRequest.getBody();
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UploadMultipartPartRequestMarshaller().marshall((UploadMultipartPartRequest)super.beforeMarshalling((AmazonWebServiceRequest)uploadMultipartPartRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            UploadMultipartPartResultJsonUnmarshaller unmarshaller = new UploadMultipartPartResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            UploadMultipartPartResult uploadMultipartPartResult = (UploadMultipartPartResult)response.getAwsResponse();
            return uploadMultipartPartResult;
        }
        finally {
            uploadMultipartPartRequest.setBody(isOrig);
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeVaultResult describeVault(DescribeVaultRequest describeVaultRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeVaultRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeVaultRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeVaultRequestMarshaller().marshall((DescribeVaultRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeVaultRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            DescribeVaultResultJsonUnmarshaller unmarshaller = new DescribeVaultResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            DescribeVaultResult describeVaultResult = (DescribeVaultResult)response.getAwsResponse();
            return describeVaultResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteVaultNotifications(DeleteVaultNotificationsRequest deleteVaultNotificationsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteVaultNotificationsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteVaultNotificationsRequest> request = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteVaultNotificationsRequestMarshaller().marshall((DeleteVaultNotificationsRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteVaultNotificationsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMultipartUploadsResult listMultipartUploads(ListMultipartUploadsRequest listMultipartUploadsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listMultipartUploadsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListMultipartUploadsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListMultipartUploadsRequestMarshaller().marshall((ListMultipartUploadsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listMultipartUploadsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            ListMultipartUploadsResultJsonUnmarshaller unmarshaller = new ListMultipartUploadsResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            ListMultipartUploadsResult listMultipartUploadsResult = (ListMultipartUploadsResult)response.getAwsResponse();
            return listMultipartUploadsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDataRetrievalPolicy(SetDataRetrievalPolicyRequest setDataRetrievalPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setDataRetrievalPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SetDataRetrievalPolicyRequest> request = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SetDataRetrievalPolicyRequestMarshaller().marshall((SetDataRetrievalPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)setDataRetrievalPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteVault(DeleteVaultRequest deleteVaultRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteVaultRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteVaultRequest> request = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteVaultRequestMarshaller().marshall((DeleteVaultRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteVaultRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            JsonResponseHandler responseHandler = new JsonResponseHandler(null);
            this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, null, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDataRetrievalPolicyResult getDataRetrievalPolicy(GetDataRetrievalPolicyRequest getDataRetrievalPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDataRetrievalPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDataRetrievalPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDataRetrievalPolicyRequestMarshaller().marshall((GetDataRetrievalPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDataRetrievalPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            GetDataRetrievalPolicyResultJsonUnmarshaller unmarshaller = new GetDataRetrievalPolicyResultJsonUnmarshaller();
            JsonResponseHandler responseHandler = new JsonResponseHandler((Unmarshaller)unmarshaller);
            response = this.invoke((Request)request, (HttpResponseHandler)responseHandler, executionContext);
            GetDataRetrievalPolicyResult getDataRetrievalPolicyResult = (GetDataRetrievalPolicyResult)response.getAwsResponse();
            return getDataRetrievalPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response, true);
        }
    }

    @Override
    public void setEndpoint(String endpoint) {
        super.setEndpoint(endpoint);
    }

    public void setEndpoint(String endpoint, String serviceName, String regionId) throws IllegalArgumentException {
        super.setEndpoint(endpoint, serviceName, regionId);
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        AWSCredentials credentials;
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        try {
            credentials = this.awsCredentialsProvider.getCredentials();
        }
        finally {
            awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.CredentialsRequestTime);
        }
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        if (originalRequest != null && originalRequest.getRequestCredentials() != null) {
            credentials = originalRequest.getRequestCredentials();
        }
        executionContext.setCredentials(credentials);
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(this.jsonErrorUnmarshallers);
        Response result = this.client.execute(request, responseHandler, (HttpResponseHandler)errorResponseHandler, executionContext);
        return result;
    }
}

