/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.glacier.model.ListMultipartUploadsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListMultipartUploadsRequestMarshaller
implements Marshaller<Request<ListMultipartUploadsRequest>, ListMultipartUploadsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ListMultipartUploadsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListMultipartUploadsRequest> marshall(ListMultipartUploadsRequest listMultipartUploadsRequest) {
        if (listMultipartUploadsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listMultipartUploadsRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/multipart-uploads";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "accountId", listMultipartUploadsRequest.getAccountId() == null ? "-" : listMultipartUploadsRequest.getAccountId());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "vaultName", listMultipartUploadsRequest.getVaultName());
        request.setResourcePath(uriResourcePath);
        if (listMultipartUploadsRequest.getLimit() != null) {
            request.addParameter("limit", StringUtils.fromString((String)listMultipartUploadsRequest.getLimit()));
        }
        if (listMultipartUploadsRequest.getUploadIdMarker() != null) {
            request.addParameter("marker", StringUtils.fromString((String)listMultipartUploadsRequest.getUploadIdMarker()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

