/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.glacier.model.InitiateJobRequest;
import com.amazonaws.services.glacier.model.JobParameters;
import com.amazonaws.services.glacier.model.transform.InventoryRetrievalJobInputJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class InitiateJobRequestMarshaller
implements Marshaller<Request<InitiateJobRequest>, InitiateJobRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public InitiateJobRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<InitiateJobRequest> marshall(InitiateJobRequest initiateJobRequest) {
        if (initiateJobRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)initiateJobRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/jobs";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "accountId", initiateJobRequest.getAccountId() == null ? "-" : initiateJobRequest.getAccountId());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "vaultName", initiateJobRequest.getVaultName());
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            JobParameters jobParameters = initiateJobRequest.getJobParameters();
            if (jobParameters != null) {
                jsonGenerator.writeStartObject();
                if (jobParameters.getFormat() != null) {
                    jsonGenerator.writeFieldName("Format").writeValue(jobParameters.getFormat());
                }
                if (jobParameters.getType() != null) {
                    jsonGenerator.writeFieldName("Type").writeValue(jobParameters.getType());
                }
                if (jobParameters.getArchiveId() != null) {
                    jsonGenerator.writeFieldName("ArchiveId").writeValue(jobParameters.getArchiveId());
                }
                if (jobParameters.getDescription() != null) {
                    jsonGenerator.writeFieldName("Description").writeValue(jobParameters.getDescription());
                }
                if (jobParameters.getSNSTopic() != null) {
                    jsonGenerator.writeFieldName("SNSTopic").writeValue(jobParameters.getSNSTopic());
                }
                if (jobParameters.getRetrievalByteRange() != null) {
                    jsonGenerator.writeFieldName("RetrievalByteRange").writeValue(jobParameters.getRetrievalByteRange());
                }
                if (jobParameters.getTier() != null) {
                    jsonGenerator.writeFieldName("Tier").writeValue(jobParameters.getTier());
                }
                if (jobParameters.getInventoryRetrievalParameters() != null) {
                    jsonGenerator.writeFieldName("InventoryRetrievalParameters");
                    InventoryRetrievalJobInputJsonMarshaller.getInstance().marshall(jobParameters.getInventoryRetrievalParameters(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

