/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.glacier.model.InitiateMultipartUploadRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class InitiateMultipartUploadRequestMarshaller
implements Marshaller<Request<InitiateMultipartUploadRequest>, InitiateMultipartUploadRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public InitiateMultipartUploadRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<InitiateMultipartUploadRequest> marshall(InitiateMultipartUploadRequest initiateMultipartUploadRequest) {
        if (initiateMultipartUploadRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)initiateMultipartUploadRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.POST);
        if (initiateMultipartUploadRequest.getArchiveDescription() != null) {
            request.addHeader("x-amz-archive-description", StringUtils.fromString((String)initiateMultipartUploadRequest.getArchiveDescription()));
        }
        if (initiateMultipartUploadRequest.getPartSize() != null) {
            request.addHeader("x-amz-part-size", StringUtils.fromString((String)initiateMultipartUploadRequest.getPartSize()));
        }
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/multipart-uploads";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "accountId", initiateMultipartUploadRequest.getAccountId() == null ? "-" : initiateMultipartUploadRequest.getAccountId());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "vaultName", initiateMultipartUploadRequest.getVaultName());
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

