/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.glacier.model.DeleteArchiveRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DeleteArchiveRequestMarshaller
implements Marshaller<Request<DeleteArchiveRequest>, DeleteArchiveRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DeleteArchiveRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DeleteArchiveRequest> marshall(DeleteArchiveRequest deleteArchiveRequest) {
        if (deleteArchiveRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteArchiveRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/archives/{archiveId}";
        uriResourcePath = uriResourcePath.replace("{accountId}", deleteArchiveRequest.getAccountId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)deleteArchiveRequest.getAccountId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{vaultName}", deleteArchiveRequest.getVaultName() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)deleteArchiveRequest.getVaultName()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{archiveId}", deleteArchiveRequest.getArchiveId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)deleteArchiveRequest.getArchiveId()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

