/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.glacier.model.VaultNotificationConfig;
import java.util.List;

public class VaultNotificationConfigJsonMarshaller {
    private static VaultNotificationConfigJsonMarshaller instance;

    public void marshall(VaultNotificationConfig vaultNotificationConfig, StructuredJsonGenerator jsonGenerator) {
        if (vaultNotificationConfig == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> eventsList;
            jsonGenerator.writeStartObject();
            if (vaultNotificationConfig.getSNSTopic() != null) {
                jsonGenerator.writeFieldName("SNSTopic").writeValue(vaultNotificationConfig.getSNSTopic());
            }
            if ((eventsList = vaultNotificationConfig.getEvents()) != null) {
                jsonGenerator.writeFieldName("Events");
                jsonGenerator.writeStartArray();
                for (String eventsListValue : eventsList) {
                    if (eventsListValue == null) continue;
                    jsonGenerator.writeValue(eventsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static VaultNotificationConfigJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new VaultNotificationConfigJsonMarshaller();
        }
        return instance;
    }
}

