/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.glacier.model.CompleteVaultLockRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CompleteVaultLockRequestMarshaller
implements Marshaller<Request<CompleteVaultLockRequest>, CompleteVaultLockRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public CompleteVaultLockRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CompleteVaultLockRequest> marshall(CompleteVaultLockRequest completeVaultLockRequest) {
        if (completeVaultLockRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)completeVaultLockRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/lock-policy/{lockId}";
        uriResourcePath = uriResourcePath.replace("{accountId}", completeVaultLockRequest.getAccountId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)completeVaultLockRequest.getAccountId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{vaultName}", completeVaultLockRequest.getVaultName() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)completeVaultLockRequest.getVaultName()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{lockId}", completeVaultLockRequest.getLockId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)completeVaultLockRequest.getLockId()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

