/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.glacier.model.GetVaultAccessPolicyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetVaultAccessPolicyRequestMarshaller
implements Marshaller<Request<GetVaultAccessPolicyRequest>, GetVaultAccessPolicyRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetVaultAccessPolicyRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetVaultAccessPolicyRequest> marshall(GetVaultAccessPolicyRequest getVaultAccessPolicyRequest) {
        if (getVaultAccessPolicyRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getVaultAccessPolicyRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/access-policy";
        uriResourcePath = uriResourcePath.replace("{accountId}", getVaultAccessPolicyRequest.getAccountId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)getVaultAccessPolicyRequest.getAccountId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{vaultName}", getVaultAccessPolicyRequest.getVaultName() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)getVaultAccessPolicyRequest.getVaultName()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

