/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.glacier.model.GlacierJobDescription;
import com.amazonaws.services.glacier.model.transform.InventoryRetrievalJobDescriptionJsonMarshaller;

public class GlacierJobDescriptionJsonMarshaller {
    private static GlacierJobDescriptionJsonMarshaller instance;

    public void marshall(GlacierJobDescription glacierJobDescription, StructuredJsonGenerator jsonGenerator) {
        if (glacierJobDescription == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (glacierJobDescription.getJobId() != null) {
                jsonGenerator.writeFieldName("JobId").writeValue(glacierJobDescription.getJobId());
            }
            if (glacierJobDescription.getJobDescription() != null) {
                jsonGenerator.writeFieldName("JobDescription").writeValue(glacierJobDescription.getJobDescription());
            }
            if (glacierJobDescription.getAction() != null) {
                jsonGenerator.writeFieldName("Action").writeValue(glacierJobDescription.getAction());
            }
            if (glacierJobDescription.getArchiveId() != null) {
                jsonGenerator.writeFieldName("ArchiveId").writeValue(glacierJobDescription.getArchiveId());
            }
            if (glacierJobDescription.getVaultARN() != null) {
                jsonGenerator.writeFieldName("VaultARN").writeValue(glacierJobDescription.getVaultARN());
            }
            if (glacierJobDescription.getCreationDate() != null) {
                jsonGenerator.writeFieldName("CreationDate").writeValue(glacierJobDescription.getCreationDate());
            }
            if (glacierJobDescription.getCompleted() != null) {
                jsonGenerator.writeFieldName("Completed").writeValue(glacierJobDescription.getCompleted().booleanValue());
            }
            if (glacierJobDescription.getStatusCode() != null) {
                jsonGenerator.writeFieldName("StatusCode").writeValue(glacierJobDescription.getStatusCode());
            }
            if (glacierJobDescription.getStatusMessage() != null) {
                jsonGenerator.writeFieldName("StatusMessage").writeValue(glacierJobDescription.getStatusMessage());
            }
            if (glacierJobDescription.getArchiveSizeInBytes() != null) {
                jsonGenerator.writeFieldName("ArchiveSizeInBytes").writeValue(glacierJobDescription.getArchiveSizeInBytes().longValue());
            }
            if (glacierJobDescription.getInventorySizeInBytes() != null) {
                jsonGenerator.writeFieldName("InventorySizeInBytes").writeValue(glacierJobDescription.getInventorySizeInBytes().longValue());
            }
            if (glacierJobDescription.getSNSTopic() != null) {
                jsonGenerator.writeFieldName("SNSTopic").writeValue(glacierJobDescription.getSNSTopic());
            }
            if (glacierJobDescription.getCompletionDate() != null) {
                jsonGenerator.writeFieldName("CompletionDate").writeValue(glacierJobDescription.getCompletionDate());
            }
            if (glacierJobDescription.getSHA256TreeHash() != null) {
                jsonGenerator.writeFieldName("SHA256TreeHash").writeValue(glacierJobDescription.getSHA256TreeHash());
            }
            if (glacierJobDescription.getArchiveSHA256TreeHash() != null) {
                jsonGenerator.writeFieldName("ArchiveSHA256TreeHash").writeValue(glacierJobDescription.getArchiveSHA256TreeHash());
            }
            if (glacierJobDescription.getRetrievalByteRange() != null) {
                jsonGenerator.writeFieldName("RetrievalByteRange").writeValue(glacierJobDescription.getRetrievalByteRange());
            }
            if (glacierJobDescription.getInventoryRetrievalParameters() != null) {
                jsonGenerator.writeFieldName("InventoryRetrievalParameters");
                InventoryRetrievalJobDescriptionJsonMarshaller.getInstance().marshall(glacierJobDescription.getInventoryRetrievalParameters(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static GlacierJobDescriptionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new GlacierJobDescriptionJsonMarshaller();
        }
        return instance;
    }
}

