/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.glacier.model.DescribeJobRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class DescribeJobRequestMarshaller
implements Marshaller<Request<DescribeJobRequest>, DescribeJobRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeJobRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<DescribeJobRequest> marshall(DescribeJobRequest describeJobRequest) {
        if (describeJobRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeJobRequest, "AmazonGlacier");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{accountId}/vaults/{vaultName}/jobs/{jobId}";
        uriResourcePath = uriResourcePath.replace("{accountId}", describeJobRequest.getAccountId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)describeJobRequest.getAccountId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{vaultName}", describeJobRequest.getVaultName() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)describeJobRequest.getVaultName()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{jobId}", describeJobRequest.getJobId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)describeJobRequest.getJobId()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

