/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.DefaultValueSupplier;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glacier.model.InitiateJobRequest;
import com.amazonaws.services.glacier.model.transform.DefaultAccountIdSupplier;

@SdkInternalApi
public class InitiateJobRequestMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("accountId").defaultValueSupplier((DefaultValueSupplier)DefaultAccountIdSupplier.getInstance()).build();
    private static final MarshallingInfo<String> VAULTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PATH).marshallLocationName("vaultName").build();
    private static final MarshallingInfo<StructuredPojo> JOBPARAMETERS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).isExplicitPayloadMember(true).build();
    private static final InitiateJobRequestMarshaller instance = new InitiateJobRequestMarshaller();

    public static InitiateJobRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(InitiateJobRequest initiateJobRequest, ProtocolMarshaller protocolMarshaller) {
        if (initiateJobRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)initiateJobRequest.getAccountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)initiateJobRequest.getVaultName(), VAULTNAME_BINDING);
            protocolMarshaller.marshall((Object)initiateJobRequest.getJobParameters(), JOBPARAMETERS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

