/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class AddTagsToVaultRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String accountId;
    private String vaultName;
    private Map<String, String> tags;

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public AddTagsToVaultRequest withAccountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    public String getVaultName() {
        return this.vaultName;
    }

    public void setVaultName(String vaultName) {
        this.vaultName = vaultName;
    }

    public AddTagsToVaultRequest withVaultName(String vaultName) {
        this.vaultName = vaultName;
        return this;
    }

    public Map<String, String> getTags() {
        if (this.tags == null) {
            this.tags = new HashMap<String, String>();
        }
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public AddTagsToVaultRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public AddTagsToVaultRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public AddTagsToVaultRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccountId() != null) {
            sb.append("AccountId: " + this.getAccountId() + ",");
        }
        if (this.getVaultName() != null) {
            sb.append("VaultName: " + this.getVaultName() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getVaultName() == null ? 0 : this.getVaultName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddTagsToVaultRequest)) {
            return false;
        }
        AddTagsToVaultRequest other = (AddTagsToVaultRequest)obj;
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getVaultName() == null ^ this.getVaultName() == null) {
            return false;
        }
        if (other.getVaultName() != null && !other.getVaultName().equals(this.getVaultName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public AddTagsToVaultRequest clone() {
        return (AddTagsToVaultRequest)super.clone();
    }
}

