/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.gamelift.model.IpProtocol;
import com.amazonaws.services.gamelift.model.transform.ContainerPortMappingMarshaller;
import java.io.Serializable;

public class ContainerPortMapping
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer containerPort;
    private Integer connectionPort;
    private String protocol;

    public void setContainerPort(Integer containerPort) {
        this.containerPort = containerPort;
    }

    public Integer getContainerPort() {
        return this.containerPort;
    }

    public ContainerPortMapping withContainerPort(Integer containerPort) {
        this.setContainerPort(containerPort);
        return this;
    }

    public void setConnectionPort(Integer connectionPort) {
        this.connectionPort = connectionPort;
    }

    public Integer getConnectionPort() {
        return this.connectionPort;
    }

    public ContainerPortMapping withConnectionPort(Integer connectionPort) {
        this.setConnectionPort(connectionPort);
        return this;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public ContainerPortMapping withProtocol(String protocol) {
        this.setProtocol(protocol);
        return this;
    }

    public ContainerPortMapping withProtocol(IpProtocol protocol) {
        this.protocol = protocol.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContainerPort() != null) {
            sb.append("ContainerPort: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getConnectionPort() != null) {
            sb.append("ConnectionPort: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getProtocol() != null) {
            sb.append("Protocol: ").append(this.getProtocol());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerPortMapping)) {
            return false;
        }
        ContainerPortMapping other = (ContainerPortMapping)obj;
        if (other.getContainerPort() == null ^ this.getContainerPort() == null) {
            return false;
        }
        if (other.getContainerPort() != null && !other.getContainerPort().equals(this.getContainerPort())) {
            return false;
        }
        if (other.getConnectionPort() == null ^ this.getConnectionPort() == null) {
            return false;
        }
        if (other.getConnectionPort() != null && !other.getConnectionPort().equals(this.getConnectionPort())) {
            return false;
        }
        if (other.getProtocol() == null ^ this.getProtocol() == null) {
            return false;
        }
        return other.getProtocol() == null || other.getProtocol().equals(this.getProtocol());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContainerPort() == null ? 0 : this.getContainerPort().hashCode());
        hashCode = 31 * hashCode + (this.getConnectionPort() == null ? 0 : this.getConnectionPort().hashCode());
        hashCode = 31 * hashCode + (this.getProtocol() == null ? 0 : this.getProtocol().hashCode());
        return hashCode;
    }

    public ContainerPortMapping clone() {
        try {
            return (ContainerPortMapping)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ContainerPortMappingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

