/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.gamelift.model.FilterInstanceStatus;
import com.amazonaws.services.gamelift.model.transform.ClaimFilterOptionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ClaimFilterOption
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> instanceStatuses;

    public List<String> getInstanceStatuses() {
        return this.instanceStatuses;
    }

    public void setInstanceStatuses(Collection<String> instanceStatuses) {
        if (instanceStatuses == null) {
            this.instanceStatuses = null;
            return;
        }
        this.instanceStatuses = new ArrayList<String>(instanceStatuses);
    }

    public ClaimFilterOption withInstanceStatuses(String ... instanceStatuses) {
        if (this.instanceStatuses == null) {
            this.setInstanceStatuses(new ArrayList<String>(instanceStatuses.length));
        }
        for (String ele : instanceStatuses) {
            this.instanceStatuses.add(ele);
        }
        return this;
    }

    public ClaimFilterOption withInstanceStatuses(Collection<String> instanceStatuses) {
        this.setInstanceStatuses(instanceStatuses);
        return this;
    }

    public ClaimFilterOption withInstanceStatuses(FilterInstanceStatus ... instanceStatuses) {
        ArrayList<String> instanceStatusesCopy = new ArrayList<String>(instanceStatuses.length);
        for (FilterInstanceStatus value : instanceStatuses) {
            instanceStatusesCopy.add(value.toString());
        }
        if (this.getInstanceStatuses() == null) {
            this.setInstanceStatuses(instanceStatusesCopy);
        } else {
            this.getInstanceStatuses().addAll(instanceStatusesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceStatuses() != null) {
            sb.append("InstanceStatuses: ").append(this.getInstanceStatuses());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClaimFilterOption)) {
            return false;
        }
        ClaimFilterOption other = (ClaimFilterOption)obj;
        if (other.getInstanceStatuses() == null ^ this.getInstanceStatuses() == null) {
            return false;
        }
        return other.getInstanceStatuses() == null || other.getInstanceStatuses().equals(this.getInstanceStatuses());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceStatuses() == null ? 0 : this.getInstanceStatuses().hashCode());
        return hashCode;
    }

    public ClaimFilterOption clone() {
        try {
            return (ClaimFilterOption)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ClaimFilterOptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

