/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fsx;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.fsx.AmazonFSxAsync;
import com.amazonaws.services.fsx.AmazonFSxAsyncClientBuilder;
import com.amazonaws.services.fsx.AmazonFSxClient;
import com.amazonaws.services.fsx.model.AssociateFileSystemAliasesRequest;
import com.amazonaws.services.fsx.model.AssociateFileSystemAliasesResult;
import com.amazonaws.services.fsx.model.CancelDataRepositoryTaskRequest;
import com.amazonaws.services.fsx.model.CancelDataRepositoryTaskResult;
import com.amazonaws.services.fsx.model.CopyBackupRequest;
import com.amazonaws.services.fsx.model.CopyBackupResult;
import com.amazonaws.services.fsx.model.CreateBackupRequest;
import com.amazonaws.services.fsx.model.CreateBackupResult;
import com.amazonaws.services.fsx.model.CreateDataRepositoryTaskRequest;
import com.amazonaws.services.fsx.model.CreateDataRepositoryTaskResult;
import com.amazonaws.services.fsx.model.CreateFileSystemFromBackupRequest;
import com.amazonaws.services.fsx.model.CreateFileSystemFromBackupResult;
import com.amazonaws.services.fsx.model.CreateFileSystemRequest;
import com.amazonaws.services.fsx.model.CreateFileSystemResult;
import com.amazonaws.services.fsx.model.DeleteBackupRequest;
import com.amazonaws.services.fsx.model.DeleteBackupResult;
import com.amazonaws.services.fsx.model.DeleteFileSystemRequest;
import com.amazonaws.services.fsx.model.DeleteFileSystemResult;
import com.amazonaws.services.fsx.model.DescribeBackupsRequest;
import com.amazonaws.services.fsx.model.DescribeBackupsResult;
import com.amazonaws.services.fsx.model.DescribeDataRepositoryTasksRequest;
import com.amazonaws.services.fsx.model.DescribeDataRepositoryTasksResult;
import com.amazonaws.services.fsx.model.DescribeFileSystemAliasesRequest;
import com.amazonaws.services.fsx.model.DescribeFileSystemAliasesResult;
import com.amazonaws.services.fsx.model.DescribeFileSystemsRequest;
import com.amazonaws.services.fsx.model.DescribeFileSystemsResult;
import com.amazonaws.services.fsx.model.DisassociateFileSystemAliasesRequest;
import com.amazonaws.services.fsx.model.DisassociateFileSystemAliasesResult;
import com.amazonaws.services.fsx.model.ListTagsForResourceRequest;
import com.amazonaws.services.fsx.model.ListTagsForResourceResult;
import com.amazonaws.services.fsx.model.TagResourceRequest;
import com.amazonaws.services.fsx.model.TagResourceResult;
import com.amazonaws.services.fsx.model.UntagResourceRequest;
import com.amazonaws.services.fsx.model.UntagResourceResult;
import com.amazonaws.services.fsx.model.UpdateFileSystemRequest;
import com.amazonaws.services.fsx.model.UpdateFileSystemResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonFSxAsyncClient
extends AmazonFSxClient
implements AmazonFSxAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonFSxAsyncClientBuilder asyncBuilder() {
        return AmazonFSxAsyncClientBuilder.standard();
    }

    AmazonFSxAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AmazonFSxAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AssociateFileSystemAliasesResult> associateFileSystemAliasesAsync(AssociateFileSystemAliasesRequest request) {
        return this.associateFileSystemAliasesAsync(request, null);
    }

    @Override
    public Future<AssociateFileSystemAliasesResult> associateFileSystemAliasesAsync(AssociateFileSystemAliasesRequest request, final AsyncHandler<AssociateFileSystemAliasesRequest, AssociateFileSystemAliasesResult> asyncHandler) {
        final AssociateFileSystemAliasesRequest finalRequest = (AssociateFileSystemAliasesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateFileSystemAliasesResult>(){

            @Override
            public AssociateFileSystemAliasesResult call() throws Exception {
                AssociateFileSystemAliasesResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeAssociateFileSystemAliases(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CancelDataRepositoryTaskResult> cancelDataRepositoryTaskAsync(CancelDataRepositoryTaskRequest request) {
        return this.cancelDataRepositoryTaskAsync(request, null);
    }

    @Override
    public Future<CancelDataRepositoryTaskResult> cancelDataRepositoryTaskAsync(CancelDataRepositoryTaskRequest request, final AsyncHandler<CancelDataRepositoryTaskRequest, CancelDataRepositoryTaskResult> asyncHandler) {
        final CancelDataRepositoryTaskRequest finalRequest = (CancelDataRepositoryTaskRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelDataRepositoryTaskResult>(){

            @Override
            public CancelDataRepositoryTaskResult call() throws Exception {
                CancelDataRepositoryTaskResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeCancelDataRepositoryTask(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CopyBackupResult> copyBackupAsync(CopyBackupRequest request) {
        return this.copyBackupAsync(request, null);
    }

    @Override
    public Future<CopyBackupResult> copyBackupAsync(CopyBackupRequest request, final AsyncHandler<CopyBackupRequest, CopyBackupResult> asyncHandler) {
        final CopyBackupRequest finalRequest = (CopyBackupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CopyBackupResult>(){

            @Override
            public CopyBackupResult call() throws Exception {
                CopyBackupResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeCopyBackup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateBackupResult> createBackupAsync(CreateBackupRequest request) {
        return this.createBackupAsync(request, null);
    }

    @Override
    public Future<CreateBackupResult> createBackupAsync(CreateBackupRequest request, final AsyncHandler<CreateBackupRequest, CreateBackupResult> asyncHandler) {
        final CreateBackupRequest finalRequest = (CreateBackupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateBackupResult>(){

            @Override
            public CreateBackupResult call() throws Exception {
                CreateBackupResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeCreateBackup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDataRepositoryTaskResult> createDataRepositoryTaskAsync(CreateDataRepositoryTaskRequest request) {
        return this.createDataRepositoryTaskAsync(request, null);
    }

    @Override
    public Future<CreateDataRepositoryTaskResult> createDataRepositoryTaskAsync(CreateDataRepositoryTaskRequest request, final AsyncHandler<CreateDataRepositoryTaskRequest, CreateDataRepositoryTaskResult> asyncHandler) {
        final CreateDataRepositoryTaskRequest finalRequest = (CreateDataRepositoryTaskRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDataRepositoryTaskResult>(){

            @Override
            public CreateDataRepositoryTaskResult call() throws Exception {
                CreateDataRepositoryTaskResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeCreateDataRepositoryTask(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateFileSystemResult> createFileSystemAsync(CreateFileSystemRequest request) {
        return this.createFileSystemAsync(request, null);
    }

    @Override
    public Future<CreateFileSystemResult> createFileSystemAsync(CreateFileSystemRequest request, final AsyncHandler<CreateFileSystemRequest, CreateFileSystemResult> asyncHandler) {
        final CreateFileSystemRequest finalRequest = (CreateFileSystemRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateFileSystemResult>(){

            @Override
            public CreateFileSystemResult call() throws Exception {
                CreateFileSystemResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeCreateFileSystem(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateFileSystemFromBackupResult> createFileSystemFromBackupAsync(CreateFileSystemFromBackupRequest request) {
        return this.createFileSystemFromBackupAsync(request, null);
    }

    @Override
    public Future<CreateFileSystemFromBackupResult> createFileSystemFromBackupAsync(CreateFileSystemFromBackupRequest request, final AsyncHandler<CreateFileSystemFromBackupRequest, CreateFileSystemFromBackupResult> asyncHandler) {
        final CreateFileSystemFromBackupRequest finalRequest = (CreateFileSystemFromBackupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateFileSystemFromBackupResult>(){

            @Override
            public CreateFileSystemFromBackupResult call() throws Exception {
                CreateFileSystemFromBackupResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeCreateFileSystemFromBackup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteBackupResult> deleteBackupAsync(DeleteBackupRequest request) {
        return this.deleteBackupAsync(request, null);
    }

    @Override
    public Future<DeleteBackupResult> deleteBackupAsync(DeleteBackupRequest request, final AsyncHandler<DeleteBackupRequest, DeleteBackupResult> asyncHandler) {
        final DeleteBackupRequest finalRequest = (DeleteBackupRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteBackupResult>(){

            @Override
            public DeleteBackupResult call() throws Exception {
                DeleteBackupResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeDeleteBackup(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteFileSystemResult> deleteFileSystemAsync(DeleteFileSystemRequest request) {
        return this.deleteFileSystemAsync(request, null);
    }

    @Override
    public Future<DeleteFileSystemResult> deleteFileSystemAsync(DeleteFileSystemRequest request, final AsyncHandler<DeleteFileSystemRequest, DeleteFileSystemResult> asyncHandler) {
        final DeleteFileSystemRequest finalRequest = (DeleteFileSystemRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteFileSystemResult>(){

            @Override
            public DeleteFileSystemResult call() throws Exception {
                DeleteFileSystemResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeDeleteFileSystem(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeBackupsResult> describeBackupsAsync(DescribeBackupsRequest request) {
        return this.describeBackupsAsync(request, null);
    }

    @Override
    public Future<DescribeBackupsResult> describeBackupsAsync(DescribeBackupsRequest request, final AsyncHandler<DescribeBackupsRequest, DescribeBackupsResult> asyncHandler) {
        final DescribeBackupsRequest finalRequest = (DescribeBackupsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeBackupsResult>(){

            @Override
            public DescribeBackupsResult call() throws Exception {
                DescribeBackupsResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeDescribeBackups(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDataRepositoryTasksResult> describeDataRepositoryTasksAsync(DescribeDataRepositoryTasksRequest request) {
        return this.describeDataRepositoryTasksAsync(request, null);
    }

    @Override
    public Future<DescribeDataRepositoryTasksResult> describeDataRepositoryTasksAsync(DescribeDataRepositoryTasksRequest request, final AsyncHandler<DescribeDataRepositoryTasksRequest, DescribeDataRepositoryTasksResult> asyncHandler) {
        final DescribeDataRepositoryTasksRequest finalRequest = (DescribeDataRepositoryTasksRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDataRepositoryTasksResult>(){

            @Override
            public DescribeDataRepositoryTasksResult call() throws Exception {
                DescribeDataRepositoryTasksResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeDescribeDataRepositoryTasks(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFileSystemAliasesResult> describeFileSystemAliasesAsync(DescribeFileSystemAliasesRequest request) {
        return this.describeFileSystemAliasesAsync(request, null);
    }

    @Override
    public Future<DescribeFileSystemAliasesResult> describeFileSystemAliasesAsync(DescribeFileSystemAliasesRequest request, final AsyncHandler<DescribeFileSystemAliasesRequest, DescribeFileSystemAliasesResult> asyncHandler) {
        final DescribeFileSystemAliasesRequest finalRequest = (DescribeFileSystemAliasesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeFileSystemAliasesResult>(){

            @Override
            public DescribeFileSystemAliasesResult call() throws Exception {
                DescribeFileSystemAliasesResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeDescribeFileSystemAliases(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFileSystemsResult> describeFileSystemsAsync(DescribeFileSystemsRequest request) {
        return this.describeFileSystemsAsync(request, null);
    }

    @Override
    public Future<DescribeFileSystemsResult> describeFileSystemsAsync(DescribeFileSystemsRequest request, final AsyncHandler<DescribeFileSystemsRequest, DescribeFileSystemsResult> asyncHandler) {
        final DescribeFileSystemsRequest finalRequest = (DescribeFileSystemsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeFileSystemsResult>(){

            @Override
            public DescribeFileSystemsResult call() throws Exception {
                DescribeFileSystemsResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeDescribeFileSystems(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateFileSystemAliasesResult> disassociateFileSystemAliasesAsync(DisassociateFileSystemAliasesRequest request) {
        return this.disassociateFileSystemAliasesAsync(request, null);
    }

    @Override
    public Future<DisassociateFileSystemAliasesResult> disassociateFileSystemAliasesAsync(DisassociateFileSystemAliasesRequest request, final AsyncHandler<DisassociateFileSystemAliasesRequest, DisassociateFileSystemAliasesResult> asyncHandler) {
        final DisassociateFileSystemAliasesRequest finalRequest = (DisassociateFileSystemAliasesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateFileSystemAliasesResult>(){

            @Override
            public DisassociateFileSystemAliasesResult call() throws Exception {
                DisassociateFileSystemAliasesResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeDisassociateFileSystemAliases(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {
        return this.tagResourceAsync(request, null);
    }

    @Override
    public Future<TagResourceResult> tagResourceAsync(TagResourceRequest request, final AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {
        final TagResourceRequest finalRequest = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<TagResourceResult>(){

            @Override
            public TagResourceResult call() throws Exception {
                TagResourceResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeTagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {
        return this.untagResourceAsync(request, null);
    }

    @Override
    public Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request, final AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {
        final UntagResourceRequest finalRequest = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UntagResourceResult>(){

            @Override
            public UntagResourceResult call() throws Exception {
                UntagResourceResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeUntagResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateFileSystemResult> updateFileSystemAsync(UpdateFileSystemRequest request) {
        return this.updateFileSystemAsync(request, null);
    }

    @Override
    public Future<UpdateFileSystemResult> updateFileSystemAsync(UpdateFileSystemRequest request, final AsyncHandler<UpdateFileSystemRequest, UpdateFileSystemResult> asyncHandler) {
        final UpdateFileSystemRequest finalRequest = (UpdateFileSystemRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateFileSystemResult>(){

            @Override
            public UpdateFileSystemResult call() throws Exception {
                UpdateFileSystemResult result = null;
                try {
                    result = AmazonFSxAsyncClient.this.executeUpdateFileSystem(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

