/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fsx.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.fsx.model.FileSystem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeFileSystemsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<FileSystem> fileSystems;
    private String nextToken;

    public List<FileSystem> getFileSystems() {
        return this.fileSystems;
    }

    public void setFileSystems(Collection<FileSystem> fileSystems) {
        if (fileSystems == null) {
            this.fileSystems = null;
            return;
        }
        this.fileSystems = new ArrayList<FileSystem>(fileSystems);
    }

    public DescribeFileSystemsResult withFileSystems(FileSystem ... fileSystems) {
        if (this.fileSystems == null) {
            this.setFileSystems(new ArrayList<FileSystem>(fileSystems.length));
        }
        for (FileSystem ele : fileSystems) {
            this.fileSystems.add(ele);
        }
        return this;
    }

    public DescribeFileSystemsResult withFileSystems(Collection<FileSystem> fileSystems) {
        this.setFileSystems(fileSystems);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public DescribeFileSystemsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFileSystems() != null) {
            sb.append("FileSystems: ").append(this.getFileSystems()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFileSystemsResult)) {
            return false;
        }
        DescribeFileSystemsResult other = (DescribeFileSystemsResult)obj;
        if (other.getFileSystems() == null ^ this.getFileSystems() == null) {
            return false;
        }
        if (other.getFileSystems() != null && !other.getFileSystems().equals(this.getFileSystems())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFileSystems() == null ? 0 : this.getFileSystems().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public DescribeFileSystemsResult clone() {
        try {
            return (DescribeFileSystemsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

