/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fsx.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fsx.model.OpenZFSDataCompressionType;
import com.amazonaws.services.fsx.model.OpenZFSNfsExport;
import com.amazonaws.services.fsx.model.OpenZFSUserOrGroupQuota;
import com.amazonaws.services.fsx.model.transform.OpenZFSCreateRootVolumeConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OpenZFSCreateRootVolumeConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String dataCompressionType;
    private List<OpenZFSNfsExport> nfsExports;
    private List<OpenZFSUserOrGroupQuota> userAndGroupQuotas;
    private Boolean copyTagsToSnapshots;
    private Boolean readOnly;

    public void setDataCompressionType(String dataCompressionType) {
        this.dataCompressionType = dataCompressionType;
    }

    public String getDataCompressionType() {
        return this.dataCompressionType;
    }

    public OpenZFSCreateRootVolumeConfiguration withDataCompressionType(String dataCompressionType) {
        this.setDataCompressionType(dataCompressionType);
        return this;
    }

    public OpenZFSCreateRootVolumeConfiguration withDataCompressionType(OpenZFSDataCompressionType dataCompressionType) {
        this.dataCompressionType = dataCompressionType.toString();
        return this;
    }

    public List<OpenZFSNfsExport> getNfsExports() {
        return this.nfsExports;
    }

    public void setNfsExports(Collection<OpenZFSNfsExport> nfsExports) {
        if (nfsExports == null) {
            this.nfsExports = null;
            return;
        }
        this.nfsExports = new ArrayList<OpenZFSNfsExport>(nfsExports);
    }

    public OpenZFSCreateRootVolumeConfiguration withNfsExports(OpenZFSNfsExport ... nfsExports) {
        if (this.nfsExports == null) {
            this.setNfsExports(new ArrayList<OpenZFSNfsExport>(nfsExports.length));
        }
        for (OpenZFSNfsExport ele : nfsExports) {
            this.nfsExports.add(ele);
        }
        return this;
    }

    public OpenZFSCreateRootVolumeConfiguration withNfsExports(Collection<OpenZFSNfsExport> nfsExports) {
        this.setNfsExports(nfsExports);
        return this;
    }

    public List<OpenZFSUserOrGroupQuota> getUserAndGroupQuotas() {
        return this.userAndGroupQuotas;
    }

    public void setUserAndGroupQuotas(Collection<OpenZFSUserOrGroupQuota> userAndGroupQuotas) {
        if (userAndGroupQuotas == null) {
            this.userAndGroupQuotas = null;
            return;
        }
        this.userAndGroupQuotas = new ArrayList<OpenZFSUserOrGroupQuota>(userAndGroupQuotas);
    }

    public OpenZFSCreateRootVolumeConfiguration withUserAndGroupQuotas(OpenZFSUserOrGroupQuota ... userAndGroupQuotas) {
        if (this.userAndGroupQuotas == null) {
            this.setUserAndGroupQuotas(new ArrayList<OpenZFSUserOrGroupQuota>(userAndGroupQuotas.length));
        }
        for (OpenZFSUserOrGroupQuota ele : userAndGroupQuotas) {
            this.userAndGroupQuotas.add(ele);
        }
        return this;
    }

    public OpenZFSCreateRootVolumeConfiguration withUserAndGroupQuotas(Collection<OpenZFSUserOrGroupQuota> userAndGroupQuotas) {
        this.setUserAndGroupQuotas(userAndGroupQuotas);
        return this;
    }

    public void setCopyTagsToSnapshots(Boolean copyTagsToSnapshots) {
        this.copyTagsToSnapshots = copyTagsToSnapshots;
    }

    public Boolean getCopyTagsToSnapshots() {
        return this.copyTagsToSnapshots;
    }

    public OpenZFSCreateRootVolumeConfiguration withCopyTagsToSnapshots(Boolean copyTagsToSnapshots) {
        this.setCopyTagsToSnapshots(copyTagsToSnapshots);
        return this;
    }

    public Boolean isCopyTagsToSnapshots() {
        return this.copyTagsToSnapshots;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public OpenZFSCreateRootVolumeConfiguration withReadOnly(Boolean readOnly) {
        this.setReadOnly(readOnly);
        return this;
    }

    public Boolean isReadOnly() {
        return this.readOnly;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDataCompressionType() != null) {
            sb.append("DataCompressionType: ").append(this.getDataCompressionType()).append(",");
        }
        if (this.getNfsExports() != null) {
            sb.append("NfsExports: ").append(this.getNfsExports()).append(",");
        }
        if (this.getUserAndGroupQuotas() != null) {
            sb.append("UserAndGroupQuotas: ").append(this.getUserAndGroupQuotas()).append(",");
        }
        if (this.getCopyTagsToSnapshots() != null) {
            sb.append("CopyTagsToSnapshots: ").append(this.getCopyTagsToSnapshots()).append(",");
        }
        if (this.getReadOnly() != null) {
            sb.append("ReadOnly: ").append(this.getReadOnly());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenZFSCreateRootVolumeConfiguration)) {
            return false;
        }
        OpenZFSCreateRootVolumeConfiguration other = (OpenZFSCreateRootVolumeConfiguration)obj;
        if (other.getDataCompressionType() == null ^ this.getDataCompressionType() == null) {
            return false;
        }
        if (other.getDataCompressionType() != null && !other.getDataCompressionType().equals(this.getDataCompressionType())) {
            return false;
        }
        if (other.getNfsExports() == null ^ this.getNfsExports() == null) {
            return false;
        }
        if (other.getNfsExports() != null && !other.getNfsExports().equals(this.getNfsExports())) {
            return false;
        }
        if (other.getUserAndGroupQuotas() == null ^ this.getUserAndGroupQuotas() == null) {
            return false;
        }
        if (other.getUserAndGroupQuotas() != null && !other.getUserAndGroupQuotas().equals(this.getUserAndGroupQuotas())) {
            return false;
        }
        if (other.getCopyTagsToSnapshots() == null ^ this.getCopyTagsToSnapshots() == null) {
            return false;
        }
        if (other.getCopyTagsToSnapshots() != null && !other.getCopyTagsToSnapshots().equals(this.getCopyTagsToSnapshots())) {
            return false;
        }
        if (other.getReadOnly() == null ^ this.getReadOnly() == null) {
            return false;
        }
        return other.getReadOnly() == null || other.getReadOnly().equals(this.getReadOnly());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDataCompressionType() == null ? 0 : this.getDataCompressionType().hashCode());
        hashCode = 31 * hashCode + (this.getNfsExports() == null ? 0 : this.getNfsExports().hashCode());
        hashCode = 31 * hashCode + (this.getUserAndGroupQuotas() == null ? 0 : this.getUserAndGroupQuotas().hashCode());
        hashCode = 31 * hashCode + (this.getCopyTagsToSnapshots() == null ? 0 : this.getCopyTagsToSnapshots().hashCode());
        hashCode = 31 * hashCode + (this.getReadOnly() == null ? 0 : this.getReadOnly().hashCode());
        return hashCode;
    }

    public OpenZFSCreateRootVolumeConfiguration clone() {
        try {
            return (OpenZFSCreateRootVolumeConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OpenZFSCreateRootVolumeConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

