/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.freetier;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.freetier.AWSFreeTierAsync;
import com.amazonaws.services.freetier.AWSFreeTierAsyncClientBuilder;
import com.amazonaws.services.freetier.AWSFreeTierClient;
import com.amazonaws.services.freetier.model.GetFreeTierUsageRequest;
import com.amazonaws.services.freetier.model.GetFreeTierUsageResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSFreeTierAsyncClient
extends AWSFreeTierClient
implements AWSFreeTierAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSFreeTierAsyncClientBuilder asyncBuilder() {
        return AWSFreeTierAsyncClientBuilder.standard();
    }

    AWSFreeTierAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSFreeTierAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<GetFreeTierUsageResult> getFreeTierUsageAsync(GetFreeTierUsageRequest request) {
        return this.getFreeTierUsageAsync(request, null);
    }

    @Override
    public Future<GetFreeTierUsageResult> getFreeTierUsageAsync(GetFreeTierUsageRequest request, final AsyncHandler<GetFreeTierUsageRequest, GetFreeTierUsageResult> asyncHandler) {
        final GetFreeTierUsageRequest finalRequest = (GetFreeTierUsageRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetFreeTierUsageResult>(){

            @Override
            public GetFreeTierUsageResult call() throws Exception {
                GetFreeTierUsageResult result = null;
                try {
                    result = AWSFreeTierAsyncClient.this.executeGetFreeTierUsage(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

