/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.frauddetector.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.frauddetector.model.Entity;
import com.amazonaws.services.frauddetector.model.transform.EventMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Event
implements Serializable,
Cloneable,
StructuredPojo {
    private String eventId;
    private String eventTypeName;
    private String eventTimestamp;
    private Map<String, String> eventVariables;
    private String currentLabel;
    private String labelTimestamp;
    private List<Entity> entities;

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public String getEventId() {
        return this.eventId;
    }

    public Event withEventId(String eventId) {
        this.setEventId(eventId);
        return this;
    }

    public void setEventTypeName(String eventTypeName) {
        this.eventTypeName = eventTypeName;
    }

    public String getEventTypeName() {
        return this.eventTypeName;
    }

    public Event withEventTypeName(String eventTypeName) {
        this.setEventTypeName(eventTypeName);
        return this;
    }

    public void setEventTimestamp(String eventTimestamp) {
        this.eventTimestamp = eventTimestamp;
    }

    public String getEventTimestamp() {
        return this.eventTimestamp;
    }

    public Event withEventTimestamp(String eventTimestamp) {
        this.setEventTimestamp(eventTimestamp);
        return this;
    }

    public Map<String, String> getEventVariables() {
        return this.eventVariables;
    }

    public void setEventVariables(Map<String, String> eventVariables) {
        this.eventVariables = eventVariables;
    }

    public Event withEventVariables(Map<String, String> eventVariables) {
        this.setEventVariables(eventVariables);
        return this;
    }

    public Event addEventVariablesEntry(String key, String value) {
        if (null == this.eventVariables) {
            this.eventVariables = new HashMap<String, String>();
        }
        if (this.eventVariables.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.eventVariables.put(key, value);
        return this;
    }

    public Event clearEventVariablesEntries() {
        this.eventVariables = null;
        return this;
    }

    public void setCurrentLabel(String currentLabel) {
        this.currentLabel = currentLabel;
    }

    public String getCurrentLabel() {
        return this.currentLabel;
    }

    public Event withCurrentLabel(String currentLabel) {
        this.setCurrentLabel(currentLabel);
        return this;
    }

    public void setLabelTimestamp(String labelTimestamp) {
        this.labelTimestamp = labelTimestamp;
    }

    public String getLabelTimestamp() {
        return this.labelTimestamp;
    }

    public Event withLabelTimestamp(String labelTimestamp) {
        this.setLabelTimestamp(labelTimestamp);
        return this;
    }

    public List<Entity> getEntities() {
        return this.entities;
    }

    public void setEntities(Collection<Entity> entities) {
        if (entities == null) {
            this.entities = null;
            return;
        }
        this.entities = new ArrayList<Entity>(entities);
    }

    public Event withEntities(Entity ... entities) {
        if (this.entities == null) {
            this.setEntities(new ArrayList<Entity>(entities.length));
        }
        for (Entity ele : entities) {
            this.entities.add(ele);
        }
        return this;
    }

    public Event withEntities(Collection<Entity> entities) {
        this.setEntities(entities);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEventId() != null) {
            sb.append("EventId: ").append(this.getEventId()).append(",");
        }
        if (this.getEventTypeName() != null) {
            sb.append("EventTypeName: ").append(this.getEventTypeName()).append(",");
        }
        if (this.getEventTimestamp() != null) {
            sb.append("EventTimestamp: ").append(this.getEventTimestamp()).append(",");
        }
        if (this.getEventVariables() != null) {
            sb.append("EventVariables: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getCurrentLabel() != null) {
            sb.append("CurrentLabel: ").append(this.getCurrentLabel()).append(",");
        }
        if (this.getLabelTimestamp() != null) {
            sb.append("LabelTimestamp: ").append(this.getLabelTimestamp()).append(",");
        }
        if (this.getEntities() != null) {
            sb.append("Entities: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event)obj;
        if (other.getEventId() == null ^ this.getEventId() == null) {
            return false;
        }
        if (other.getEventId() != null && !other.getEventId().equals(this.getEventId())) {
            return false;
        }
        if (other.getEventTypeName() == null ^ this.getEventTypeName() == null) {
            return false;
        }
        if (other.getEventTypeName() != null && !other.getEventTypeName().equals(this.getEventTypeName())) {
            return false;
        }
        if (other.getEventTimestamp() == null ^ this.getEventTimestamp() == null) {
            return false;
        }
        if (other.getEventTimestamp() != null && !other.getEventTimestamp().equals(this.getEventTimestamp())) {
            return false;
        }
        if (other.getEventVariables() == null ^ this.getEventVariables() == null) {
            return false;
        }
        if (other.getEventVariables() != null && !other.getEventVariables().equals(this.getEventVariables())) {
            return false;
        }
        if (other.getCurrentLabel() == null ^ this.getCurrentLabel() == null) {
            return false;
        }
        if (other.getCurrentLabel() != null && !other.getCurrentLabel().equals(this.getCurrentLabel())) {
            return false;
        }
        if (other.getLabelTimestamp() == null ^ this.getLabelTimestamp() == null) {
            return false;
        }
        if (other.getLabelTimestamp() != null && !other.getLabelTimestamp().equals(this.getLabelTimestamp())) {
            return false;
        }
        if (other.getEntities() == null ^ this.getEntities() == null) {
            return false;
        }
        return other.getEntities() == null || other.getEntities().equals(this.getEntities());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEventId() == null ? 0 : this.getEventId().hashCode());
        hashCode = 31 * hashCode + (this.getEventTypeName() == null ? 0 : this.getEventTypeName().hashCode());
        hashCode = 31 * hashCode + (this.getEventTimestamp() == null ? 0 : this.getEventTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getEventVariables() == null ? 0 : this.getEventVariables().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentLabel() == null ? 0 : this.getCurrentLabel().hashCode());
        hashCode = 31 * hashCode + (this.getLabelTimestamp() == null ? 0 : this.getLabelTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getEntities() == null ? 0 : this.getEntities().hashCode());
        return hashCode;
    }

    public Event clone() {
        try {
            return (Event)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

