/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.frauddetector.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.frauddetector.model.transform.RuleResultMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RuleResult
implements Serializable,
Cloneable,
StructuredPojo {
    private String ruleId;
    private List<String> outcomes;

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public RuleResult withRuleId(String ruleId) {
        this.setRuleId(ruleId);
        return this;
    }

    public List<String> getOutcomes() {
        return this.outcomes;
    }

    public void setOutcomes(Collection<String> outcomes) {
        if (outcomes == null) {
            this.outcomes = null;
            return;
        }
        this.outcomes = new ArrayList<String>(outcomes);
    }

    public RuleResult withOutcomes(String ... outcomes) {
        if (this.outcomes == null) {
            this.setOutcomes(new ArrayList<String>(outcomes.length));
        }
        for (String ele : outcomes) {
            this.outcomes.add(ele);
        }
        return this;
    }

    public RuleResult withOutcomes(Collection<String> outcomes) {
        this.setOutcomes(outcomes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRuleId() != null) {
            sb.append("RuleId: ").append(this.getRuleId()).append(",");
        }
        if (this.getOutcomes() != null) {
            sb.append("Outcomes: ").append(this.getOutcomes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleResult)) {
            return false;
        }
        RuleResult other = (RuleResult)obj;
        if (other.getRuleId() == null ^ this.getRuleId() == null) {
            return false;
        }
        if (other.getRuleId() != null && !other.getRuleId().equals(this.getRuleId())) {
            return false;
        }
        if (other.getOutcomes() == null ^ this.getOutcomes() == null) {
            return false;
        }
        return other.getOutcomes() == null || other.getOutcomes().equals(this.getOutcomes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRuleId() == null ? 0 : this.getRuleId().hashCode());
        hashCode = 31 * hashCode + (this.getOutcomes() == null ? 0 : this.getOutcomes().hashCode());
        return hashCode;
    }

    public RuleResult clone() {
        try {
            return (RuleResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RuleResultMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

