/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.forecast.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.forecast.model.FeaturizationConfig;
import java.util.List;

@SdkInternalApi
public class FeaturizationConfigMarshaller {
    private static final MarshallingInfo<String> FORECASTFREQUENCY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ForecastFrequency").build();
    private static final MarshallingInfo<List> FORECASTDIMENSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ForecastDimensions").build();
    private static final MarshallingInfo<List> FEATURIZATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Featurizations").build();
    private static final FeaturizationConfigMarshaller instance = new FeaturizationConfigMarshaller();

    public static FeaturizationConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(FeaturizationConfig featurizationConfig, ProtocolMarshaller protocolMarshaller) {
        if (featurizationConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)featurizationConfig.getForecastFrequency(), FORECASTFREQUENCY_BINDING);
            protocolMarshaller.marshall(featurizationConfig.getForecastDimensions(), FORECASTDIMENSIONS_BINDING);
            protocolMarshaller.marshall(featurizationConfig.getFeaturizations(), FEATURIZATIONS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

