/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.forecast.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.forecast.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateMonitorRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String monitorName;
    private String resourceArn;
    private List<Tag> tags;

    public void setMonitorName(String monitorName) {
        this.monitorName = monitorName;
    }

    public String getMonitorName() {
        return this.monitorName;
    }

    public CreateMonitorRequest withMonitorName(String monitorName) {
        this.setMonitorName(monitorName);
        return this;
    }

    public void setResourceArn(String resourceArn) {
        this.resourceArn = resourceArn;
    }

    public String getResourceArn() {
        return this.resourceArn;
    }

    public CreateMonitorRequest withResourceArn(String resourceArn) {
        this.setResourceArn(resourceArn);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateMonitorRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateMonitorRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMonitorName() != null) {
            sb.append("MonitorName: ").append(this.getMonitorName()).append(",");
        }
        if (this.getResourceArn() != null) {
            sb.append("ResourceArn: ").append(this.getResourceArn()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMonitorRequest)) {
            return false;
        }
        CreateMonitorRequest other = (CreateMonitorRequest)obj;
        if (other.getMonitorName() == null ^ this.getMonitorName() == null) {
            return false;
        }
        if (other.getMonitorName() != null && !other.getMonitorName().equals(this.getMonitorName())) {
            return false;
        }
        if (other.getResourceArn() == null ^ this.getResourceArn() == null) {
            return false;
        }
        if (other.getResourceArn() != null && !other.getResourceArn().equals(this.getResourceArn())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMonitorName() == null ? 0 : this.getMonitorName().hashCode());
        hashCode = 31 * hashCode + (this.getResourceArn() == null ? 0 : this.getResourceArn().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateMonitorRequest clone() {
        return (CreateMonitorRequest)super.clone();
    }
}

