/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fms.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fms.model.transform.RegionScopeMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RegionScope
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> regions;
    private Boolean allRegionsEnabled;

    public List<String> getRegions() {
        return this.regions;
    }

    public void setRegions(Collection<String> regions) {
        if (regions == null) {
            this.regions = null;
            return;
        }
        this.regions = new ArrayList<String>(regions);
    }

    public RegionScope withRegions(String ... regions) {
        if (this.regions == null) {
            this.setRegions(new ArrayList<String>(regions.length));
        }
        for (String ele : regions) {
            this.regions.add(ele);
        }
        return this;
    }

    public RegionScope withRegions(Collection<String> regions) {
        this.setRegions(regions);
        return this;
    }

    public void setAllRegionsEnabled(Boolean allRegionsEnabled) {
        this.allRegionsEnabled = allRegionsEnabled;
    }

    public Boolean getAllRegionsEnabled() {
        return this.allRegionsEnabled;
    }

    public RegionScope withAllRegionsEnabled(Boolean allRegionsEnabled) {
        this.setAllRegionsEnabled(allRegionsEnabled);
        return this;
    }

    public Boolean isAllRegionsEnabled() {
        return this.allRegionsEnabled;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRegions() != null) {
            sb.append("Regions: ").append(this.getRegions()).append(",");
        }
        if (this.getAllRegionsEnabled() != null) {
            sb.append("AllRegionsEnabled: ").append(this.getAllRegionsEnabled());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegionScope)) {
            return false;
        }
        RegionScope other = (RegionScope)obj;
        if (other.getRegions() == null ^ this.getRegions() == null) {
            return false;
        }
        if (other.getRegions() != null && !other.getRegions().equals(this.getRegions())) {
            return false;
        }
        if (other.getAllRegionsEnabled() == null ^ this.getAllRegionsEnabled() == null) {
            return false;
        }
        return other.getAllRegionsEnabled() == null || other.getAllRegionsEnabled().equals(this.getAllRegionsEnabled());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRegions() == null ? 0 : this.getRegions().hashCode());
        hashCode = 31 * hashCode + (this.getAllRegionsEnabled() == null ? 0 : this.getAllRegionsEnabled().hashCode());
        return hashCode;
    }

    public RegionScope clone() {
        try {
            return (RegionScope)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RegionScopeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

