/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.finspacedata.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.finspacedata.model.ColumnDefinition;
import com.amazonaws.services.finspacedata.model.transform.SchemaDefinitionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SchemaDefinition
implements Serializable,
Cloneable,
StructuredPojo {
    private List<ColumnDefinition> columns;
    private List<String> primaryKeyColumns;

    public List<ColumnDefinition> getColumns() {
        return this.columns;
    }

    public void setColumns(Collection<ColumnDefinition> columns) {
        if (columns == null) {
            this.columns = null;
            return;
        }
        this.columns = new ArrayList<ColumnDefinition>(columns);
    }

    public SchemaDefinition withColumns(ColumnDefinition ... columns) {
        if (this.columns == null) {
            this.setColumns(new ArrayList<ColumnDefinition>(columns.length));
        }
        for (ColumnDefinition ele : columns) {
            this.columns.add(ele);
        }
        return this;
    }

    public SchemaDefinition withColumns(Collection<ColumnDefinition> columns) {
        this.setColumns(columns);
        return this;
    }

    public List<String> getPrimaryKeyColumns() {
        return this.primaryKeyColumns;
    }

    public void setPrimaryKeyColumns(Collection<String> primaryKeyColumns) {
        if (primaryKeyColumns == null) {
            this.primaryKeyColumns = null;
            return;
        }
        this.primaryKeyColumns = new ArrayList<String>(primaryKeyColumns);
    }

    public SchemaDefinition withPrimaryKeyColumns(String ... primaryKeyColumns) {
        if (this.primaryKeyColumns == null) {
            this.setPrimaryKeyColumns(new ArrayList<String>(primaryKeyColumns.length));
        }
        for (String ele : primaryKeyColumns) {
            this.primaryKeyColumns.add(ele);
        }
        return this;
    }

    public SchemaDefinition withPrimaryKeyColumns(Collection<String> primaryKeyColumns) {
        this.setPrimaryKeyColumns(primaryKeyColumns);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getColumns() != null) {
            sb.append("Columns: ").append(this.getColumns()).append(",");
        }
        if (this.getPrimaryKeyColumns() != null) {
            sb.append("PrimaryKeyColumns: ").append(this.getPrimaryKeyColumns());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaDefinition)) {
            return false;
        }
        SchemaDefinition other = (SchemaDefinition)obj;
        if (other.getColumns() == null ^ this.getColumns() == null) {
            return false;
        }
        if (other.getColumns() != null && !other.getColumns().equals(this.getColumns())) {
            return false;
        }
        if (other.getPrimaryKeyColumns() == null ^ this.getPrimaryKeyColumns() == null) {
            return false;
        }
        return other.getPrimaryKeyColumns() == null || other.getPrimaryKeyColumns().equals(this.getPrimaryKeyColumns());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getColumns() == null ? 0 : this.getColumns().hashCode());
        hashCode = 31 * hashCode + (this.getPrimaryKeyColumns() == null ? 0 : this.getPrimaryKeyColumns().hashCode());
        return hashCode;
    }

    public SchemaDefinition clone() {
        try {
            return (SchemaDefinition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SchemaDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

