/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.finspacedata.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.finspacedata.model.ResourcePermission;
import com.amazonaws.services.finspacedata.model.transform.PermissionGroupParamsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PermissionGroupParams
implements Serializable,
Cloneable,
StructuredPojo {
    private String permissionGroupId;
    private List<ResourcePermission> datasetPermissions;

    public void setPermissionGroupId(String permissionGroupId) {
        this.permissionGroupId = permissionGroupId;
    }

    public String getPermissionGroupId() {
        return this.permissionGroupId;
    }

    public PermissionGroupParams withPermissionGroupId(String permissionGroupId) {
        this.setPermissionGroupId(permissionGroupId);
        return this;
    }

    public List<ResourcePermission> getDatasetPermissions() {
        return this.datasetPermissions;
    }

    public void setDatasetPermissions(Collection<ResourcePermission> datasetPermissions) {
        if (datasetPermissions == null) {
            this.datasetPermissions = null;
            return;
        }
        this.datasetPermissions = new ArrayList<ResourcePermission>(datasetPermissions);
    }

    public PermissionGroupParams withDatasetPermissions(ResourcePermission ... datasetPermissions) {
        if (this.datasetPermissions == null) {
            this.setDatasetPermissions(new ArrayList<ResourcePermission>(datasetPermissions.length));
        }
        for (ResourcePermission ele : datasetPermissions) {
            this.datasetPermissions.add(ele);
        }
        return this;
    }

    public PermissionGroupParams withDatasetPermissions(Collection<ResourcePermission> datasetPermissions) {
        this.setDatasetPermissions(datasetPermissions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPermissionGroupId() != null) {
            sb.append("PermissionGroupId: ").append(this.getPermissionGroupId()).append(",");
        }
        if (this.getDatasetPermissions() != null) {
            sb.append("DatasetPermissions: ").append(this.getDatasetPermissions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PermissionGroupParams)) {
            return false;
        }
        PermissionGroupParams other = (PermissionGroupParams)obj;
        if (other.getPermissionGroupId() == null ^ this.getPermissionGroupId() == null) {
            return false;
        }
        if (other.getPermissionGroupId() != null && !other.getPermissionGroupId().equals(this.getPermissionGroupId())) {
            return false;
        }
        if (other.getDatasetPermissions() == null ^ this.getDatasetPermissions() == null) {
            return false;
        }
        return other.getDatasetPermissions() == null || other.getDatasetPermissions().equals(this.getDatasetPermissions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPermissionGroupId() == null ? 0 : this.getPermissionGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getDatasetPermissions() == null ? 0 : this.getDatasetPermissions().hashCode());
        return hashCode;
    }

    public PermissionGroupParams clone() {
        try {
            return (PermissionGroupParams)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PermissionGroupParamsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

