/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.finspacedata.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.finspacedata.model.DataViewDestinationTypeParams;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateDataViewRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clientToken;
    private String datasetId;
    private Boolean autoUpdate;
    private List<String> sortColumns;
    private List<String> partitionColumns;
    private Long asOfTimestamp;
    private DataViewDestinationTypeParams destinationTypeParams;

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateDataViewRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setDatasetId(String datasetId) {
        this.datasetId = datasetId;
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public CreateDataViewRequest withDatasetId(String datasetId) {
        this.setDatasetId(datasetId);
        return this;
    }

    public void setAutoUpdate(Boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public Boolean getAutoUpdate() {
        return this.autoUpdate;
    }

    public CreateDataViewRequest withAutoUpdate(Boolean autoUpdate) {
        this.setAutoUpdate(autoUpdate);
        return this;
    }

    public Boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public List<String> getSortColumns() {
        return this.sortColumns;
    }

    public void setSortColumns(Collection<String> sortColumns) {
        if (sortColumns == null) {
            this.sortColumns = null;
            return;
        }
        this.sortColumns = new ArrayList<String>(sortColumns);
    }

    public CreateDataViewRequest withSortColumns(String ... sortColumns) {
        if (this.sortColumns == null) {
            this.setSortColumns(new ArrayList<String>(sortColumns.length));
        }
        for (String ele : sortColumns) {
            this.sortColumns.add(ele);
        }
        return this;
    }

    public CreateDataViewRequest withSortColumns(Collection<String> sortColumns) {
        this.setSortColumns(sortColumns);
        return this;
    }

    public List<String> getPartitionColumns() {
        return this.partitionColumns;
    }

    public void setPartitionColumns(Collection<String> partitionColumns) {
        if (partitionColumns == null) {
            this.partitionColumns = null;
            return;
        }
        this.partitionColumns = new ArrayList<String>(partitionColumns);
    }

    public CreateDataViewRequest withPartitionColumns(String ... partitionColumns) {
        if (this.partitionColumns == null) {
            this.setPartitionColumns(new ArrayList<String>(partitionColumns.length));
        }
        for (String ele : partitionColumns) {
            this.partitionColumns.add(ele);
        }
        return this;
    }

    public CreateDataViewRequest withPartitionColumns(Collection<String> partitionColumns) {
        this.setPartitionColumns(partitionColumns);
        return this;
    }

    public void setAsOfTimestamp(Long asOfTimestamp) {
        this.asOfTimestamp = asOfTimestamp;
    }

    public Long getAsOfTimestamp() {
        return this.asOfTimestamp;
    }

    public CreateDataViewRequest withAsOfTimestamp(Long asOfTimestamp) {
        this.setAsOfTimestamp(asOfTimestamp);
        return this;
    }

    public void setDestinationTypeParams(DataViewDestinationTypeParams destinationTypeParams) {
        this.destinationTypeParams = destinationTypeParams;
    }

    public DataViewDestinationTypeParams getDestinationTypeParams() {
        return this.destinationTypeParams;
    }

    public CreateDataViewRequest withDestinationTypeParams(DataViewDestinationTypeParams destinationTypeParams) {
        this.setDestinationTypeParams(destinationTypeParams);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getDatasetId() != null) {
            sb.append("DatasetId: ").append(this.getDatasetId()).append(",");
        }
        if (this.getAutoUpdate() != null) {
            sb.append("AutoUpdate: ").append(this.getAutoUpdate()).append(",");
        }
        if (this.getSortColumns() != null) {
            sb.append("SortColumns: ").append(this.getSortColumns()).append(",");
        }
        if (this.getPartitionColumns() != null) {
            sb.append("PartitionColumns: ").append(this.getPartitionColumns()).append(",");
        }
        if (this.getAsOfTimestamp() != null) {
            sb.append("AsOfTimestamp: ").append(this.getAsOfTimestamp()).append(",");
        }
        if (this.getDestinationTypeParams() != null) {
            sb.append("DestinationTypeParams: ").append(this.getDestinationTypeParams());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataViewRequest)) {
            return false;
        }
        CreateDataViewRequest other = (CreateDataViewRequest)obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getDatasetId() == null ^ this.getDatasetId() == null) {
            return false;
        }
        if (other.getDatasetId() != null && !other.getDatasetId().equals(this.getDatasetId())) {
            return false;
        }
        if (other.getAutoUpdate() == null ^ this.getAutoUpdate() == null) {
            return false;
        }
        if (other.getAutoUpdate() != null && !other.getAutoUpdate().equals(this.getAutoUpdate())) {
            return false;
        }
        if (other.getSortColumns() == null ^ this.getSortColumns() == null) {
            return false;
        }
        if (other.getSortColumns() != null && !other.getSortColumns().equals(this.getSortColumns())) {
            return false;
        }
        if (other.getPartitionColumns() == null ^ this.getPartitionColumns() == null) {
            return false;
        }
        if (other.getPartitionColumns() != null && !other.getPartitionColumns().equals(this.getPartitionColumns())) {
            return false;
        }
        if (other.getAsOfTimestamp() == null ^ this.getAsOfTimestamp() == null) {
            return false;
        }
        if (other.getAsOfTimestamp() != null && !other.getAsOfTimestamp().equals(this.getAsOfTimestamp())) {
            return false;
        }
        if (other.getDestinationTypeParams() == null ^ this.getDestinationTypeParams() == null) {
            return false;
        }
        return other.getDestinationTypeParams() == null || other.getDestinationTypeParams().equals(this.getDestinationTypeParams());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getDatasetId() == null ? 0 : this.getDatasetId().hashCode());
        hashCode = 31 * hashCode + (this.getAutoUpdate() == null ? 0 : this.getAutoUpdate().hashCode());
        hashCode = 31 * hashCode + (this.getSortColumns() == null ? 0 : this.getSortColumns().hashCode());
        hashCode = 31 * hashCode + (this.getPartitionColumns() == null ? 0 : this.getPartitionColumns().hashCode());
        hashCode = 31 * hashCode + (this.getAsOfTimestamp() == null ? 0 : this.getAsOfTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationTypeParams() == null ? 0 : this.getDestinationTypeParams().hashCode());
        return hashCode;
    }

    public CreateDataViewRequest clone() {
        return (CreateDataViewRequest)super.clone();
    }
}

